/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.listener;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.tooling.ui.widgets.listener.IdleEventListenerDispatcher;

public class IdleEventListenerPoller
implements Runnable {
    private static final long MIN_IDLE_TIME = 100L;
    private Object listenersLock = new Object();
    private List<IdleEventListenerDispatcher<?>> registeredListeners = new ArrayList();
    private Thread thread;
    private boolean stopped;
    private long idleTime;

    private static IdleEventListenerPoller instance() {
        return Singleton.instance;
    }

    public static void register(IdleEventListenerDispatcher<?> listener) {
        IdleEventListenerPoller.instance()._register(listener);
    }

    public static void unregister(IdleEventListenerDispatcher<?> listener) {
        IdleEventListenerPoller.instance()._unregister(listener);
    }

    public static void notifyEvent() {
        IdleEventListenerPoller.instance()._notifyEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _register(IdleEventListenerDispatcher<?> listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.registeredListeners.add(listener);
            if (this.registeredListeners.size() == 1) {
                this.start();
            }
        }
    }

    private long calculateIdleTime() {
        Iterator<IdleEventListenerDispatcher<?>> iterator = this.registeredListeners.iterator();
        BigInteger gcd = BigInteger.valueOf(iterator.next().getIdleTime());
        while (iterator.hasNext()) {
            gcd = BigInteger.valueOf(iterator.next().getIdleTime()).gcd(gcd);
        }
        return Math.max(gcd.longValue(), 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _unregister(IdleEventListenerDispatcher<?> listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.registeredListeners.remove(listener);
            if (this.registeredListeners.isEmpty()) {
                this.stop();
            } else {
                this.idleTime = this.calculateIdleTime();
            }
        }
    }

    private void start() {
        this.stopped = false;
        this.idleTime = this.calculateIdleTime();
        this.thread = new Thread((Runnable)this, "Idle Event Listeners Poller");
        this.thread.start();
    }

    private void stop() {
        this.stopped = true;
        this.idleTime = 0L;
        this.thread.interrupt();
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            Object object = this.listenersLock;
            synchronized (object) {
                for (IdleEventListenerDispatcher<?> listener : this.registeredListeners) {
                    listener.checkAndDispatch();
                }
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait(this.idleTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _notifyEvent() {
        IdleEventListenerPoller idleEventListenerPoller = this;
        synchronized (idleEventListenerPoller) {
            this.notify();
        }
    }

    private static class Singleton {
        private static final IdleEventListenerPoller instance = new IdleEventListenerPoller();

        private Singleton() {
        }
    }
}

