/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.listener;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.widgets.listener.IdleEventListenerPoller;

public abstract class IdleEventListenerDispatcher<T> {
    public static final long DEFAULT_TIME_WAIT = 1000L;
    private long idleTime;
    private long eventTime;
    private Display display;
    private T currentEvent;

    public IdleEventListenerDispatcher(long idleTime, Control target) {
        this.idleTime = idleTime;
        this.display = target.getDisplay();
        target.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    IdleEventListenerPoller.unregister(IdleEventListenerDispatcher.this);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        IdleEventListenerPoller.register(this);
    }

    protected abstract void callListener(T var1);

    protected void onEvent(T event) {
        this.currentEvent = event;
        this.eventTime = System.currentTimeMillis();
        IdleEventListenerPoller.notifyEvent();
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public void checkAndDispatch() {
        long elapsed = System.currentTimeMillis() - this.eventTime;
        final T thisEvent = this.currentEvent;
        if (thisEvent != null && elapsed > this.idleTime) {
            this.currentEvent = null;
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IdleEventListenerDispatcher.this.callListener(thisEvent);
                }
            });
        }
    }
}

