/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.group;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.listener.ICollapseListener;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;

public abstract class CollapsibleGroupComposite
extends Composite {
    private static Image collapseImgBlue = WidgetsImages.getImage("icons/collapse-arrow-open-blue.png");
    private static Image expandImgBlue = WidgetsImages.getImage("icons/collapse-arrow-closed-blue.png");
    private FormData contentFormData;
    private Group group;
    private CLabel text;
    private Composite content;
    private Composite groupComposite;
    private List<ICollapseListener> listeners = new LinkedList<ICollapseListener>();
    private boolean isCollapsed;

    public abstract void setContent(Composite var1);

    public abstract String getGroupTitle();

    public CollapsibleGroupComposite(Composite parent, int groupStyle) {
        this(parent, groupStyle, true);
    }

    public CollapsibleGroupComposite(Composite parent, int groupStyle, boolean isInitiallyCollapsed) {
        super(parent, 262144);
        this.setLayout((Layout)new FormLayout());
        this.group = new Group((Composite)this, groupStyle);
        this.group.setLayout((Layout)new FormLayout());
        FormLayoutUtils.attach((Control)this.group).left().right();
        this.text = new CLabel((Composite)this.group, 0);
        this.initializeAndSetGroupTitle();
        this.groupComposite = new Composite((Composite)this.group, 0);
        this.groupComposite.setLayout((Layout)new FormLayout());
        FormLayoutUtils.attach((Control)this.groupComposite).left().topFrom((Control)this.text, 5);
        this.content = new Composite(this.groupComposite, 0);
        this.content.setLayout((Layout)new FormLayout());
        FormLayoutUtils.attach((Control)this.content).left().right().topFrom((Control)this.text, 5);
        this.setContent(this.content);
        this.initializeContentFormData();
        this.groupComposite.setLayoutData((Object)this.contentFormData);
        if (isInitiallyCollapsed) {
            this.setGroupCollapsed();
        } else {
            this.setGroupExpanded();
        }
        this.isCollapsed = isInitiallyCollapsed;
    }

    private void initializeContentFormData() {
        this.contentFormData = new FormData();
        this.contentFormData.top = new FormAttachment((Control)this.text, 0, 1024);
        this.contentFormData.bottom = new FormAttachment(100);
        this.contentFormData.left = new FormAttachment();
        this.contentFormData.right = new FormAttachment(100);
    }

    private void initializeAndSetGroupTitle() {
        this.text.setCursor(this.getDisplay().getSystemCursor(21));
        this.text.setImage(collapseImgBlue);
        this.text.setText(this.getGroupTitle());
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CollapsibleGroupComposite.this.toogle();
            }
        });
        FormLayoutUtils.attach((Control)this.text).left().top();
    }

    private void toogle() {
        boolean bl = this.isCollapsed = !this.isCollapsed;
        if (this.isCollapsed) {
            this.setGroupCollapsed();
        } else {
            this.setGroupExpanded();
        }
    }

    public void setGroupCollapsed() {
        FormData zeroData = new FormData();
        zeroData.height = 0;
        zeroData.width = this.contentFormData.width;
        this.text.setImage(expandImgBlue);
        this.groupComposite.setLayoutData((Object)zeroData);
        this.getParent().pack();
        this.notifyListeners();
    }

    public void setGroupExpanded() {
        this.text.setImage(collapseImgBlue);
        this.groupComposite.setLayoutData((Object)this.contentFormData);
        this.getParent().pack();
        this.notifyListeners();
    }

    public void addCollapseListener(ICollapseListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (ICollapseListener listener : this.listeners) {
            if (this.isExpanded()) {
                listener.onExpand();
                continue;
            }
            listener.onCollapse();
        }
    }

    public boolean isExpanded() {
        return !this.isCollapsed;
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }
}

