/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.group;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.listener.ICollapseListener;

public class CollapsableGroup
extends Composite {
    private String id = UUID.randomUUID().toString();
    private Label button;
    private Label text;
    private Group group;
    private Composite content;
    private List<ICollapseListener> collapseListeners;
    private Listener resizeListener;
    private boolean isDefaultCollapsed;
    private boolean isCollapsed;
    private Image collapseImgBold;
    private Image expandImgBold;

    public CollapsableGroup(Composite parent, int style) {
        this(parent, style, false);
    }

    public CollapsableGroup(Composite parent, int style, boolean collapsed) {
        super(parent, 4);
        this.isDefaultCollapsed = collapsed;
        this.collapseListeners = new ArrayList<ICollapseListener>();
        this.collapseImgBold = WidgetsImages.getImage("icons/collapse-arrow-open.png");
        this.expandImgBold = WidgetsImages.getImage("icons/collapse-arrow-closed.png");
        this.createContents(style);
        this.listenForChanges();
    }

    public void createContents(int style) {
        super.setLayout((Layout)new CollapsableLayout());
        this.button = new Label((Composite)this, 0);
        this.button.setImage(this.isDefaultCollapsed ? this.collapseImgBold : this.expandImgBold);
        this.button.setCursor(this.getDisplay().getSystemCursor(21));
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CollapsableGroup.this.toogle();
            }
        };
        this.button.addMouseListener((MouseListener)listener);
        this.text = new Label((Composite)this, 0);
        this.text.setCursor(this.getDisplay().getSystemCursor(21));
        this.text.addMouseListener((MouseListener)listener);
        this.isCollapsed = false;
        this.group = new Group((Composite)this, style);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.group);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.group);
        this.content = new Composite((Composite)this.group, 0);
        if (this.isDefaultCollapsed) {
            this.toogle();
        }
    }

    public void toogle() {
        this.isCollapsed = !this.isCollapsed;
        this.button.setImage(this.isCollapsed ? this.collapseImgBold : this.expandImgBold);
        this.repaint();
        this.notifyListeners();
    }

    private void listenForChanges() {
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                CollapsableGroup.this.repaint();
            }
        };
        if (this.getParent() != null) {
            this.getParent().addListener(11, this.resizeListener);
        }
        this.addListener(11, this.resizeListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Composite parent = CollapsableGroup.this.getParent();
                if (parent != null) {
                    parent.removeListener(11, CollapsableGroup.this.resizeListener);
                    CollapsableGroup.this.removeDisposeListener(this);
                }
            }
        });
    }

    public Layout getLayout() {
        return this.content.getLayout();
    }

    public void setLayout(Layout layout) {
        this.content.setLayout(layout);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public Font getFont() {
        return this.text.getFont();
    }

    public void setFont(Font font) {
        this.text.setFont(font);
    }

    public Composite getContent() {
        return this.content;
    }

    public boolean setFocus() {
        return this.content.setFocus();
    }

    public boolean isExpanded() {
        return !this.isCollapsed;
    }

    public boolean isCollapsed() {
        return !this.isExpanded();
    }

    public void addCollapseListener(ICollapseListener listener) {
        this.collapseListeners.add(listener);
    }

    private void repaint() {
        this.layout();
        if (this.getParent() != null) {
            this.getParent().layout();
        }
    }

    public void notifyListeners() {
        for (ICollapseListener listener : this.collapseListeners) {
            if (this.isExpanded()) {
                listener.onExpand();
                continue;
            }
            listener.onCollapse();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public class CollapsableLayout
    extends Layout {
        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int parentWidth = composite.getParent().getBounds().width;
            Point buttonSize = CollapsableGroup.this.button.computeSize(-1, -1);
            Point textSize = CollapsableGroup.this.text.computeSize(-1, -1);
            int height = Math.max(buttonSize.y + 2, textSize.y);
            if (CollapsableGroup.this.isExpanded()) {
                Point groupSize = CollapsableGroup.this.group.computeSize(-1, -1);
                height += groupSize.y;
            }
            return new Point(parentWidth, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Point buttonSize = CollapsableGroup.this.button.computeSize(-1, -1);
            Point textSize = CollapsableGroup.this.text.computeSize(-1, -1);
            int height = Math.max(buttonSize.y + 2, textSize.y);
            CollapsableGroup.this.button.setBounds(10, height - buttonSize.y >> 1, buttonSize.x, buttonSize.y);
            CollapsableGroup.this.text.setBounds(12 + buttonSize.x, height - textSize.y >> 1, textSize.x, textSize.y);
            if (CollapsableGroup.this.isExpanded()) {
                Point groupSize = CollapsableGroup.this.group.computeSize(-1, -1);
                CollapsableGroup.this.group.setBounds(0, height, composite.getSize().x, groupSize.y);
            } else {
                CollapsableGroup.this.group.setBounds(0, height, composite.getSize().x, 0);
            }
        }
    }
}

