/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.errors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ErrorManager<K, V> {
    private Map<K, List<V>> issues = new HashMap<K, List<V>>();
    private List<ErrorManagerListener> listeners = new ArrayList<ErrorManagerListener>();

    public boolean haveIssues(K document) {
        if (document == null) {
            return false;
        }
        if (!this.issues.containsKey(document)) {
            return false;
        }
        List<V> issuesList = this.issues.get(document);
        if (issuesList == null) {
            return false;
        }
        return !issuesList.isEmpty();
    }

    public List<V> getIssues(K document) {
        return this.issues.get(document);
    }

    public void addIssue(K document, V issue) {
        if (this.issues.containsKey(document)) {
            this.issues.get(document).add(issue);
        } else {
            ArrayList<V> issuesList = new ArrayList<V>();
            issuesList.add(issue);
            this.issues.put(document, issuesList);
        }
        this.onIssuesModified();
    }

    public void clearIssues(K document) {
        this.issues.remove(document);
        this.onIssuesModified();
    }

    public void clear() {
        this.issues.clear();
        this.onIssuesModified();
    }

    public synchronized void addListener(ErrorManagerListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ErrorManagerListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void onIssuesModified() {
        for (ErrorManagerListener errorManagerListener : this.listeners) {
            errorManagerListener.onManagerModifier();
        }
    }

    public boolean areIssues() {
        Collection<List<V>> values = this.issues.values();
        for (List<V> list : values) {
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public int issuesSize() {
        int issuesNumber = 0;
        if (!this.issues.isEmpty()) {
            for (List<V> issueList : this.issues.values()) {
                if (issueList == null) continue;
                issuesNumber += issueList.size();
            }
        }
        return issuesNumber;
    }

    public synchronized void clearListeners() {
        this.listeners.clear();
    }

    public boolean areAll(Predicate<V> apply) {
        if (!this.issues.isEmpty()) {
            for (List<V> issueList : this.issues.values()) {
                boolean all;
                if (issueList == null || (all = issueList.stream().allMatch(apply))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void deleteAll(K document, Predicate<V> apply) {
        Collection toDelete;
        List<V> list = this.issues.get(document);
        if (list != null && !list.isEmpty() && !(toDelete = (Collection)list.stream().filter(apply).collect(Collectors.toSet())).isEmpty()) {
            list.removeAll(toDelete);
            if (list.isEmpty()) {
                this.issues.remove(document);
            }
            this.onIssuesModified();
        }
    }

    @FunctionalInterface
    public static interface ErrorManagerListener {
        public void onManagerModifier();
    }
}

