/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.errors;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.ui.widgets.errors.ErrorItem;
import org.mule.tooling.ui.widgets.errors.IErrorListProvider;
import org.mule.tooling.ui.widgets.menu.IContextMenuProvider;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class ErrorListDialog
extends TitleAreaDialog {
    private static final String ERROR_LIST_DIALOG_CSS_ID = "org-mule-tooling-ui-widgets-ErrorListDialog";
    private static final String DEFAULT_TITLE = "List of Warnings and Errors";
    private static final String DEFAULT_MESSAGE = "Select a warning or error notification to see more details";
    private static final int TITLE_MAX_CHARACTERS = 100;
    private static final String DEFAULT_FIRST_COLUMN_NAME = "Name";
    private static final String DEFAULT_SECOND_COLUMN_NAME = "Target";
    private String initialTitle = "List of Warnings and Errors";
    private String initialMessage = "Select a warning or error notification to see more details";
    private String firstColumnName = "Name";
    private String secondColumnName = "Target";
    private TableViewer errorListViewer;
    private Text errorDetails;
    private String defaultErrorDetail = "";
    private SelectionAdapter selectionAdapter;
    private boolean showFirstColumnOnly;
    private IErrorListProvider errorsProvider;
    private IContextMenuProvider<ErrorItem> contextMenuProvider;
    private IErrorItemPresenter errorPresenter;
    private IDoubleClickListener doubleClickListener;

    public ErrorListDialog(Shell parentShell, IErrorListProvider errorsProvider) {
        this(parentShell, errorsProvider, new EmptyContextMenuProvider());
    }

    public ErrorListDialog(Shell parentShell, IErrorListProvider errorsProvider, IContextMenuProvider<ErrorItem> contextMenuProvider) {
        super(parentShell);
        this.errorsProvider = errorsProvider;
        this.contextMenuProvider = contextMenuProvider;
        this.errorPresenter = new DefaultErrorItemPresenter();
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public void setErrorPresenter(IErrorItemPresenter errorPresenter) {
        this.errorPresenter = errorPresenter;
    }

    protected Control createDialogArea(Composite parent) {
        Composite errorDialogArea = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.swtDefaults().equalWidth(true).applyTo(errorDialogArea);
        SashForm graphicalView = new SashForm(errorDialogArea, 516);
        GridLayoutFactory.swtDefaults().equalWidth(true).applyTo((Composite)graphicalView);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(450, 150).applyTo((Control)graphicalView);
        this.setTitle(this.initialTitle);
        this.errorListViewer = this.createTableViewer((Composite)graphicalView);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(450, 150).applyTo(this.errorListViewer.getControl());
        this.errorListViewer.setInput(this.errorsProvider.getIssues());
        this.errorDetails = new Text((Composite)graphicalView, 2890);
        this.errorDetails.setText(this.defaultErrorDetail);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(800, 150).applyTo((Control)this.errorDetails);
        this.addListeners();
        this.createContextMenu();
        this.setMessage(this.initialMessage);
        ThemeUtils.setCssId(errorDialogArea, ERROR_LIST_DIALOG_CSS_ID);
        return parent;
    }

    protected void addListeners() {
        this.errorListViewer.addSelectionChangedListener((ISelectionChangedListener)new ErrorTableSelectionListener(this.errorDetails));
        if (this.doubleClickListener != null) {
            this.errorListViewer.addDoubleClickListener(this.doubleClickListener);
        }
    }

    public void setDoubleClickListener(IDoubleClickListener doubleClickListener) {
        this.doubleClickListener = doubleClickListener;
    }

    public void setContextMenuProvider(IContextMenuProvider<ErrorItem> contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    private TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 68354);
        TableLayout tableLayout = new TableLayout();
        viewer.getTable().setLayout((Layout)tableLayout);
        if (this.showFirstColumnOnly) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
            this.createTableViewerColumn(viewer, this.firstColumnName);
        } else {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
            this.createTableViewerColumn(viewer, this.firstColumnName);
            this.createTableViewerColumn(viewer, this.secondColumnName);
        }
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        return viewer;
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 516);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        return viewerColumn;
    }

    public void setSelectionAdapter(SelectionAdapter selectionAdapter) {
        this.selectionAdapter = selectionAdapter;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected Point getInitialSize() {
        return new Point(450, 500);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.selectionAdapter != null) {
            button.addSelectionListener((SelectionListener)this.selectionAdapter);
        }
    }

    public void setShowFirstColumnOnly(boolean showFirstColumnOnly) {
        this.showFirstColumnOnly = showFirstColumnOnly;
    }

    public void setDefaultErrorDetail(String defaultDetail) {
        this.defaultErrorDetail = defaultDetail;
    }

    public void setInitialTitle(String initialTitle) {
        this.initialTitle = initialTitle;
    }

    public void setInitialMessage(String initialMessage) {
        this.initialMessage = initialMessage;
    }

    public void setFirstColumnName(String firstColumnName) {
        this.firstColumnName = firstColumnName;
    }

    public void setSecondColumnName(String secondColumnName) {
        this.secondColumnName = secondColumnName;
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ErrorItem selected = (ErrorItem)((StructuredSelection)ErrorListDialog.this.errorListViewer.getSelection()).getFirstElement();
                ErrorListDialog.this.contextMenuProvider.addActions(manager, Optional.ofNullable(selected));
            }
        });
        Menu menu = menuManager.createContextMenu(this.errorListViewer.getControl());
        this.errorListViewer.getControl().setMenu(menu);
    }

    public static class DefaultErrorItemPresenter
    implements IErrorItemPresenter {
        @Override
        public String getFirstColumnValue(ErrorItem errorItem) {
            return errorItem.getTitle();
        }

        @Override
        public String getSecondColumnValue(ErrorItem errorItem) {
            return errorItem.getMessage();
        }
    }

    private static class EmptyContextMenuProvider
    implements IContextMenuProvider<ErrorItem> {
        private EmptyContextMenuProvider() {
        }

        @Override
        public void addActions(IMenuManager manager, Optional<ErrorItem> maybeSelectedElement) {
        }
    }

    private static final class ErrorTableSelectionListener
    implements ISelectionChangedListener {
        private Text detailsArea;

        public ErrorTableSelectionListener(Text detailsArea) {
            this.detailsArea = detailsArea;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selectedElement instanceof ErrorItem) {
                this.detailsArea.setText(((ErrorItem)selectedElement).getDescription());
            } else {
                this.detailsArea.setText("");
            }
        }
    }

    public static interface IErrorItemPresenter {
        public String getFirstColumnValue(ErrorItem var1);

        public String getSecondColumnValue(ErrorItem var1);
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ErrorItem)element).getType().getImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return StringUtils.substring((String)ErrorListDialog.this.errorPresenter.getFirstColumnValue((ErrorItem)element), (int)0, (int)100);
            }
            return StringUtils.substring((String)ErrorListDialog.this.errorPresenter.getSecondColumnValue((ErrorItem)element), (int)0, (int)100);
        }
    }
}

