/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.errors;

import org.mule.tooling.ui.widgets.errors.ErrorType;

public class ErrorItem {
    private ErrorType type;
    private String title;
    private String message;
    private String description;
    private String location;

    private ErrorItem(ErrorItemBuilder builder) {
        this.type = builder.type;
        this.title = builder.title;
        this.message = builder.message;
        this.description = builder.description;
        this.location = builder.location;
    }

    public ErrorType getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocation() {
        return this.location;
    }

    public static ErrorItemBuilder builder() {
        return new ErrorItemBuilder();
    }

    public static final class ErrorItemBuilder {
        private String title;
        private String message;
        private String description;
        private String location;
        private ErrorType type;

        public ErrorItemBuilder withTitle(String title) {
            this.title = title;
            return this;
        }

        public ErrorItemBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        public ErrorItemBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public ErrorItemBuilder withErrorType(ErrorType type) {
            this.type = type;
            return this;
        }

        public ErrorItemBuilder withLocation(String location) {
            this.location = location;
            return this;
        }

        public ErrorItem build() {
            return new ErrorItem(this);
        }
    }
}

