/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.errors;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.errors.ErrorListDialog;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.ui.widgets.errors.ErrorType;
import org.mule.tooling.ui.widgets.errors.IErrorListProvider;

public class ErrorDisplay<K, V>
extends Action {
    private static final String NO_ERRORS_LABEL = "";
    private IToolBarManager targetManager;
    private ErrorManager<K, V> errorManager;
    private IErrorListProvider errorsProvider;
    private boolean amountOfIssuesOnLabel = true;

    public ErrorDisplay(IToolBarManager targetManager, IErrorListProvider errorsProvider, ErrorManager<K, V> errorManager) {
        super(NO_ERRORS_LABEL);
        this.targetManager = targetManager;
        this.errorsProvider = errorsProvider;
        this.errorManager = errorManager;
        this.addListeners();
    }

    public void setAmountOfIssuesOnLabel(boolean amountOfIssuesOnLabel) {
        this.amountOfIssuesOnLabel = amountOfIssuesOnLabel;
    }

    protected void addListeners() {
        ErrorManager.ErrorManagerListener listener = new ErrorManager.ErrorManagerListener(){

            @Override
            public void onManagerModifier() {
                ErrorDisplay.this.onManagerModify();
            }
        };
        this.errorManager.addListener(listener);
    }

    private void onManagerModify() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ErrorDisplay.this.errorManager.areIssues()) {
                    ErrorDisplay.this.onIssues();
                } else {
                    ErrorDisplay.this.onEmpty();
                }
                ErrorDisplay.this.targetManager.update(true);
            }
        });
    }

    protected void onEmpty() {
        this.setImageDescriptor(this.getEmptyImageDescriptor());
        if (this.amountOfIssuesOnLabel) {
            this.setText(NO_ERRORS_LABEL);
        } else {
            this.setToolTipText(this.calculateOnIssuesLabel());
        }
        this.setEnabled(false);
    }

    protected ImageDescriptor getEmptyImageDescriptor() {
        return WidgetsImages.getImageDescriptor("icons/errors/empty.png");
    }

    protected void onIssues() {
        this.setEnabled(true);
        this.setImageDescriptor(this.getErrorDisplayImage());
        if (this.amountOfIssuesOnLabel) {
            this.setText(this.calculateOnIssuesLabel());
        } else {
            this.setToolTipText(this.calculateOnIssuesLabel());
        }
    }

    protected String calculateOnIssuesLabel() {
        return this.getIssuesLabel(this.errorManager.issuesSize());
    }

    protected ImageDescriptor getErrorDisplayImage() {
        return ErrorType.ERROR.getImageDescriptor();
    }

    protected String getIssuesLabel(int foundIssues) {
        if (foundIssues == 1) {
            return "1 issue found";
        }
        if (foundIssues > 1) {
            return foundIssues + " issues found";
        }
        return NO_ERRORS_LABEL;
    }

    public void run() {
        ErrorListDialog errorDialog = new ErrorListDialog(this.getShell(), this.errorsProvider);
        errorDialog.open();
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }

    public IToolBarManager getTargetManager() {
        return this.targetManager;
    }

    public void setTargetManager(IToolBarManager targetManager) {
        this.targetManager = targetManager;
    }

    public ErrorManager<K, V> getErrorManager() {
        return this.errorManager;
    }

    public void setErrorManager(ErrorManager<K, V> errorManager) {
        this.errorManager = errorManager;
    }

    public IErrorListProvider getErrorsCalculator() {
        return this.errorsProvider;
    }

    public void setErrorsCalculator(IErrorListProvider errorsCalculator) {
        this.errorsProvider = errorsCalculator;
    }
}

