/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.editor;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DisplayMessageDialog
extends MessageDialog {
    public DisplayMessageDialog(Shell parentShell, String dialogTitle, Image titleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, titleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public static boolean open(int kind, Shell parent, String title, String message, int style) {
        DisplayMessageDialog dialog = new DisplayMessageDialog(parent, title, null, message, kind, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.setShellStyle(dialog.getShellStyle() | (style &= 0x10000000));
        return dialog.open() == 0;
    }

    public static void openError(Shell parent, String title, String message) {
        DisplayMessageDialog.open(1, parent, title, message, 0);
    }

    public static void openWarning(Shell parent, String title, String message) {
        DisplayMessageDialog.open(4, parent, title, message, 0);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            Text text = new Text(composite, 66);
            text.setText(this.message);
            text.setBackground(Display.getDefault().getSystemColor(22));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        }
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }
}

