/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.dynamic.table;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContentType;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicRow;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManager;
import org.mule.tooling.ui.widgets.dynamic.table.events.IContentTypeSelectionChanged;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class TypedDynamicRow
extends DynamicRow {
    private ComboViewer typeCombo;
    private ParameterTypeSelectionChanged selectionListener;
    private DynamicContentType currentType;

    public TypedDynamicRow(Composite parent, EventBus eventBus, TypesManager typesManager) {
        super(parent, eventBus, typesManager);
    }

    @Override
    public void setContentType(DynamicContentType newType) {
        super.setContentType(newType);
        this.typeCombo.setSelection((ISelection)new StructuredSelection((Object)newType));
    }

    @Override
    protected void doCreateControls() {
        this.typeCombo = new ComboViewer(this.getWrappper(), 8);
        GridData gridData = GridDataFactory.fillDefaults().create();
        gridData.widthHint = 150;
        this.typeCombo.getControl().setLayoutData((Object)gridData);
        this.typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeCombo.setLabelProvider((IBaseLabelProvider)new ParameterTypeLabelProvider());
        List<DynamicContentType> contentOptions = this.getContentOptions();
        this.typeCombo.setInput(contentOptions);
        this.typeCombo.setSelection((ISelection)new StructuredSelection((Object)contentOptions.get(0)));
        this.selectionListener = new ParameterTypeSelectionChanged();
        this.typeCombo.addSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
    }

    @Override
    protected DynamicContentType getType() {
        StructuredSelection selection = (StructuredSelection)this.typeCombo.getSelection();
        if (!selection.isEmpty()) {
            return (DynamicContentType)selection.getFirstElement();
        }
        return this.getContentOptions().get(0);
    }

    private void notifyContentChanged() {
        this.getEventBus().fireEvent((IEvent)new IEvent<IContentTypeSelectionChanged>(){

            public EventType<IContentTypeSelectionChanged> getAssociatedType() {
                return IContentTypeSelectionChanged.ON_TABLE_SELECTION_TYPE_CHANGED;
            }

            public void dispatch(IContentTypeSelectionChanged handler) {
                TypedDynamicRow.this.setLoading(true);
                handler.selectionChange();
                TypedDynamicRow.this.setLoading(false);
            }
        });
    }

    @Override
    public void update() {
        this.setLoading(true);
        Object save = this.save();
        StructuredSelection selection = (StructuredSelection)this.typeCombo.getSelection();
        DynamicContentType selectedElement = null;
        if (!selection.isEmpty()) {
            selectedElement = (DynamicContentType)selection.getFirstElement();
        }
        List<DynamicContentType> types = this.getContentOptions();
        if (selectedElement != null && !types.contains(selectedElement)) {
            types.add(selectedElement);
        }
        this.typeCombo.setInput(types);
        if (!selection.isEmpty()) {
            this.typeCombo.setSelection((ISelection)selection);
            this.createSelectionContent();
        }
        this.getContent().getPersistenceStrategy().load(save);
        this.setLoading(false);
    }

    private class ParameterTypeLabelProvider
    extends LabelProvider {
        private ParameterTypeLabelProvider() {
        }

        public String getText(Object element) {
            return element.toString();
        }
    }

    private class ParameterTypeSelectionChanged
    implements ISelectionChangedListener {
        private ParameterTypeSelectionChanged() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DynamicContentType selectedType = TypedDynamicRow.this.getType();
            if (selectedType.equals(TypedDynamicRow.this.currentType)) {
                return;
            }
            TypedDynamicRow.this.currentType = selectedType;
            TypedDynamicRow.this.createSelectionContent();
            if (!TypedDynamicRow.this.isLoading()) {
                TypedDynamicRow.this.notifyContentChanged();
            }
        }
    }
}

