/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.dynamic.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContentConfiguration;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContentType;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicRow;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicTableImages;
import org.mule.tooling.ui.widgets.dynamic.table.TypedDynamicRow;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManager;
import org.mule.tooling.ui.widgets.dynamic.table.events.IContentTypeSelectionChanged;
import org.mule.tooling.ui.widgets.dynamic.table.events.ITableRowDeletedListener;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public abstract class DynamicTable
extends Composite {
    private List<DynamicRow> rows;
    private Composite rowsWrapper;
    private ToolBar toolbar;
    private Composite emptyCanvasComposite;
    private List<ITableContentChangedListener> tableContentChangedListeners = new ArrayList<ITableContentChangedListener>();
    private EventBus eventBus;
    private EventBusHelper eventHelper = new EventBusHelper();
    private Boolean useLeftAlignment = Boolean.FALSE;
    private Button addRowButton;

    public DynamicTable(Composite parent, EventBus eventBus) {
        super(parent, 0);
        this.rows = new ArrayList<DynamicRow>();
        this.eventBus = eventBus;
    }

    public List<DynamicRow> getRows() {
        return this.rows;
    }

    public void createControls() {
        Composite container = new Composite((Composite)this, 4);
        GridLayoutFactory.fillDefaults().applyTo(container);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)container);
        if (this.shouldCreateTitle()) {
            this.createTitle(container);
        }
        this.rowsWrapper = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.rowsWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rowsWrapper);
        this.createEmptyCanvasInformation();
        Composite buttonsWrapper = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonsWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonsWrapper);
        this.addRowButton = new Button(buttonsWrapper, 0x100000);
        this.addRowButton.setText(this.getAddRowButtonLabel());
        this.addRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DynamicTable.this.getTypesManager().getTypes().isEmpty()) {
                    MessageDialog.openInformation((Shell)DynamicTable.this.getParent().getShell(), null, (String)"You have already selected all available values");
                } else {
                    DynamicTable.this.addRow();
                }
            }
        });
        this.eventHelper.registerUIListener(this.getEventBus(), ITableRowDeletedListener.ON_TABLE_ROW_DELETED, (IEventHandler)new ITableRowDeletedListener(){

            @Override
            public void removed(DynamicRow row) {
                DynamicTable.this.onParameterRemoved(row);
            }
        });
        this.eventHelper.registerUIListener(this.getEventBus(), IContentTypeSelectionChanged.ON_TABLE_SELECTION_TYPE_CHANGED, (IEventHandler)new IContentTypeSelectionChanged(){

            @Override
            public void selectionChange() {
                DynamicTable.this.updateTypes();
            }
        });
        this.eventHelper.unregisterWith((Widget)this.getParent());
    }

    private void onParameterRemoved(DynamicRow parameter) {
        if (!this.rows.isEmpty()) {
            this.rows.remove(parameter);
            if (this.rows.isEmpty()) {
                this.createEmptyCanvasInformation();
            }
            this.onRowsChanged(true);
        }
    }

    private void createTitle(Composite parent) {
        Composite titleWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).extendedMargins(5, 5, 5, 0).applyTo(titleWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)titleWrapper);
        Label titleLabel = new Label(titleWrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000008).grab(true, false).applyTo((Control)titleLabel);
        titleLabel.setText(this.getEditorTitle());
        this.toolbar = new ToolBar(titleWrapper, 4);
        ToolBarManager rowsToolbarManager = new ToolBarManager(this.toolbar);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.toolbar);
        rowsToolbarManager.add((IAction)new RemoveAllRowsAction());
        rowsToolbarManager.update(true);
        Label separatorLabel = new Label(parent, 258);
        GridDataFactory.fillDefaults().applyTo((Control)separatorLabel);
        separatorLabel.setEnabled(false);
    }

    protected void onRowsChanged(boolean fireEvents) {
        this.updateTypes();
        this.layout(true, true);
        if (fireEvents) {
            this.notifyListeners();
        }
    }

    private void updateTypes() {
        this.updateSelectedTypes();
        for (DynamicRow row : this.getRows()) {
            row.update();
        }
    }

    private void updateSelectedTypes() {
        ArrayList<DynamicContentType> selectedTypes = new ArrayList<DynamicContentType>();
        for (DynamicRow row : this.getRows()) {
            selectedTypes.add(row.getContentType());
        }
        this.getTypesManager().setSelectedTypes(selectedTypes);
    }

    private DynamicRow createRow() {
        return this.createRow(this.rowsWrapper, this.getEventBus(), this.getTypesManager());
    }

    protected DynamicRow createRow(Composite parent, EventBus eventBus, TypesManager typesManager) {
        return new TypedDynamicRow(parent, eventBus, typesManager);
    }

    protected void addAllRows(List<DynamicRow> dynamicRows, boolean fireEvents) {
        if (this.rows.isEmpty()) {
            this.emptyCanvasComposite.dispose();
        }
        this.rows.addAll(dynamicRows);
        this.enableToolbar(true);
        this.onRowsChanged(fireEvents);
    }

    protected DynamicRow addRow() {
        DynamicRow newRow = this.createRow();
        this.addRow(newRow);
        return newRow;
    }

    protected void addRow(DynamicRow row) {
        if (this.rows.isEmpty()) {
            this.emptyCanvasComposite.dispose();
        }
        this.rows.add(row);
        this.enableToolbar(true);
        this.onRowsChanged(true);
    }

    public void addRow(DynamicContentConfiguration config) {
        Optional<DynamicContentType> type = this.getTypesManager().getType(config.getId());
        if (type.isPresent()) {
            DynamicRow newRow = this.createRow();
            newRow.setContentType(type.get());
            newRow.getContent().getPersistenceStrategy().load(config);
            this.addRow(newRow);
        }
    }

    public void addRows(Collection<? extends DynamicContentConfiguration> configs, boolean fireEvents) {
        ArrayList<DynamicRow> dynamicRows = new ArrayList<DynamicRow>();
        for (DynamicContentConfiguration dynamicContentConfiguration : configs) {
            Optional<DynamicContentType> type = this.getTypesManager().getType(dynamicContentConfiguration.getId());
            if (!type.isPresent()) continue;
            DynamicRow newRow = this.createRow();
            newRow.setLoading(true);
            newRow.setContentType(type.get());
            newRow.getContent().getPersistenceStrategy().load(dynamicContentConfiguration);
            newRow.setLoading(false);
            dynamicRows.add(newRow);
        }
        if (dynamicRows.size() > 0) {
            this.addAllRows(dynamicRows, fireEvents);
        }
    }

    public void clearRows() {
        Control[] controlArray = this.rowsWrapper.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                control.dispose();
            }
            ++n2;
        }
        this.rows.clear();
        this.createEmptyCanvasInformation();
        this.onRowsChanged(true);
    }

    private void createEmptyCanvasInformation() {
        this.emptyCanvasComposite = new Composite(this.rowsWrapper, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).extendedMargins(5, 5, 5, 5).applyTo(this.emptyCanvasComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.emptyCanvasComposite);
        Label emptyCanvasLabel = new Label(this.emptyCanvasComposite, 0x1000000);
        emptyCanvasLabel.setText(this.getEmptyMessage());
        if (this.useLeftAlignment.booleanValue()) {
            GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, true).applyTo((Control)emptyCanvasLabel);
        } else {
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)emptyCanvasLabel);
        }
        this.enableToolbar(false);
    }

    private void enableToolbar(boolean enabled) {
        if (this.shouldCreateTitle()) {
            this.toolbar.setEnabled(enabled);
        }
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    protected boolean rowExist(DynamicContentType type, String paramName) {
        return false;
    }

    public void setUseLeftAlignmentInText(Boolean useLeftAlignment) {
        this.useLeftAlignment = useLeftAlignment;
    }

    protected abstract String getEditorTitle();

    protected abstract String getEmptyMessage();

    protected abstract String getAddRowButtonLabel();

    protected abstract TypesManager getTypesManager();

    protected abstract String getDeleteAllConfirmationQuestion();

    protected abstract String getDeleteAllTitle();

    protected abstract boolean shouldCreateTitle();

    public void addTableContentChangedListener(ITableContentChangedListener listener) {
        this.tableContentChangedListeners.add(listener);
    }

    public void removeTableContentChangedListener(ITableContentChangedListener listener) {
        this.tableContentChangedListeners.remove(listener);
    }

    protected void notifyListeners() {
        for (ITableContentChangedListener listener : this.tableContentChangedListeners) {
            listener.contentChanged();
        }
    }

    public static interface ITableContentChangedListener {
        public void contentChanged();
    }

    private class RemoveAllRowsAction
    extends Action {
        public RemoveAllRowsAction() {
            this.setImageDescriptor(DynamicTableImages.REMOVE_ALL_PARAMETER_IMAGE);
            this.setId(DynamicTable.this.getDeleteAllTitle());
            this.setToolTipText(DynamicTable.this.getDeleteAllTitle());
        }

        public void run() {
            boolean sure = MessageDialog.openQuestion((Shell)DynamicTable.this.getParent().getShell(), (String)DynamicTable.this.getDeleteAllTitle(), (String)DynamicTable.this.getDeleteAllConfirmationQuestion());
            if (sure) {
                DynamicTable.this.clearRows();
            }
        }
    }
}

