/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.dynamic.table;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContent;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContentConfiguration;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContentType;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicTableImages;
import org.mule.tooling.ui.widgets.dynamic.table.TablePersistenceStrategy;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManager;
import org.mule.tooling.ui.widgets.dynamic.table.events.ITableRowDeletedListener;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public abstract class DynamicRow {
    private EventBus eventBus;
    private Composite rowsContainer;
    private Composite errorWrapper;
    private ToolBar toolbar;
    private Composite wrapper;
    private TypesManager typesManager;
    private Composite contentWrapper;
    private DynamicContent content;
    private DynamicContentType contentType;
    private boolean loading;

    public DynamicRow(Composite parent, EventBus eventBus, TypesManager typesManager) {
        this.rowsContainer = parent;
        this.eventBus = eventBus;
        this.typesManager = typesManager;
        this.createControls();
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public DynamicContent getContent() {
        return this.content;
    }

    public DynamicContentType getContentType() {
        return this.contentType;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public TypesManager getTypesManager() {
        return this.typesManager;
    }

    public void showError(String message) {
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.errorWrapper);
        GridDataFactory.fillDefaults().applyTo((Control)this.errorWrapper);
        Label errorLabel = new Label(this.errorWrapper, 0);
        errorLabel.setImage(WidgetsImages.ERROR_IMAGE);
        errorLabel.setToolTipText(message);
        GridDataFactory.fillDefaults().grab(false, true).align(0x1000008, 0x1000000).applyTo((Control)errorLabel);
        this.wrapper.layout(true, true);
    }

    public void clearError() {
        Control[] controlArray = this.errorWrapper.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!child.isDisposed()) {
                child.dispose();
            }
            ++n2;
        }
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.errorWrapper);
        GridDataFactory.fillDefaults().minSize(0, 0).applyTo((Control)this.errorWrapper);
        this.wrapper.layout(true, true);
    }

    public void setContentType(DynamicContentType newType) {
        if (!this.getContentOptions().contains(newType)) {
            return;
        }
        this.contentType = newType;
    }

    public <T extends DynamicContentConfiguration> T save() {
        TablePersistenceStrategy persistenceStrategy = this.getContent().getPersistenceStrategy();
        DynamicContentConfiguration config = (DynamicContentConfiguration)persistenceStrategy.save();
        config.setId(this.getContentType().getId());
        return (T)config;
    }

    protected void createControls() {
        this.wrapper = new Composite(this.rowsContainer, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.wrapper);
        this.errorWrapper = new Composite(this.wrapper, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.errorWrapper);
        GridDataFactory.fillDefaults().minSize(0, 0).applyTo((Control)this.errorWrapper);
        this.doCreateControls();
        this.createSelectionContent();
    }

    protected void createSelectionContent() {
        if (this.toolbar != null) {
            this.toolbar.dispose();
        }
        if (this.contentWrapper != null) {
            this.contentWrapper.dispose();
            this.content = null;
        }
        this.contentWrapper = this.createParameterWrapper(this.getWrappper());
        this.contentType = this.getType();
        this.content = this.contentType.getFactory().create();
        this.createContent();
        this.toolbar = this.createParameterToolbar(this.getWrappper());
    }

    protected Composite getWrappper() {
        return this.wrapper;
    }

    protected Composite getRowsContainer() {
        return this.rowsContainer;
    }

    private ToolBar createParameterToolbar(Composite wrapper) {
        ToolBar toolbar = new ToolBar(wrapper, 4);
        ToolBarManager parametersToolbarManager = new ToolBarManager(toolbar);
        parametersToolbarManager.add((IAction)new RemoveParameterAction());
        parametersToolbarManager.update(true);
        return toolbar;
    }

    private Composite createParameterWrapper(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        return wrapper;
    }

    private void notifyContentRemoved() {
        this.eventBus.fireEvent((IEvent)new IEvent<ITableRowDeletedListener>(){

            public EventType<ITableRowDeletedListener> getAssociatedType() {
                return ITableRowDeletedListener.ON_TABLE_ROW_DELETED;
            }

            public void dispatch(ITableRowDeletedListener handler) {
                handler.removed(DynamicRow.this);
            }
        });
    }

    private void createContent() {
        this.content.createControls(this.contentWrapper);
    }

    protected List<DynamicContentType> getContentOptions() {
        return this.getTypesManager().getTypes();
    }

    public abstract void update();

    protected abstract DynamicContentType getType();

    protected abstract void doCreateControls();

    private class RemoveParameterAction
    extends Action {
        public RemoveParameterAction() {
            super("remove");
            this.setImageDescriptor(DynamicTableImages.REMOVE_PARAMETER_IMAGE);
        }

        public void run() {
            DynamicRow.this.getWrappper().dispose();
            DynamicRow.this.getRowsContainer().layout();
            DynamicRow.this.notifyContentRemoved();
        }
    }
}

