/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.dialog;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.ui.widgets.dialog.IDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.IEditorMessageLogger;

public class TitleAreaEditorDialog<T extends Composite>
extends TitleAreaDialog
implements IEditorMessageLogger {
    private Point size;
    private final Class<T> editorClazz;
    private final IDialogEditorPresenter<T> controller;
    private final String title;
    private final String message;
    private T editor;
    private boolean done = false;
    private Map<Object, List<UserMessage>> messages = new HashMap<Object, List<UserMessage>>();

    public TitleAreaEditorDialog(Shell parentShell, Class<T> editor, IDialogEditorPresenter<T> controller, String title, String message) {
        super(parentShell);
        this.editorClazz = editor;
        this.controller = controller;
        this.title = title;
        this.message = message;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        try {
            Constructor<T> constructor = this.editorClazz.getConstructor(Composite.class, Integer.TYPE);
            this.editor = (Composite)constructor.newInstance(parent, 0);
            this.editor.setLayoutData((Object)new GridData(1808));
            this.controller.setMessageLogger(this);
            this.controller.handle(this.editor);
            return this.editor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return parent;
        }
    }

    public T getEditor() {
        return this.editor;
    }

    protected void okPressed() {
        this.controller.validate();
        if (!Iterables.concat(this.messages.values()).iterator().hasNext()) {
            this.controller.onSave();
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        this.controller.onCancel();
        super.cancelPressed();
    }

    public boolean close() {
        if (!this.done) {
            this.controller.onCancel();
        }
        return super.close();
    }

    protected Point getInitialSize() {
        if (this.size != null) {
            return this.size;
        }
        return super.getInitialSize();
    }

    protected boolean isResizable() {
        return true;
    }

    public void setSize(Point size) {
        this.size = size;
    }

    public void setSize(int width, int height) {
        this.size = new Point(width, height);
    }

    @Override
    public void errorMessage(Object owner, String logMessage, int messageId) {
        UserMessage userMessage = new UserMessage(3, logMessage, messageId);
        this.addMessage(owner, userMessage);
        this.logNextMessage();
    }

    @Override
    public void warningMessage(Object owner, String logMessage, int messageId) {
        UserMessage userMessage = new UserMessage(2, logMessage, messageId);
        this.addMessage(owner, userMessage);
        this.logNextMessage();
    }

    private void addMessage(Object owner, UserMessage userMessage) {
        if (!this.messages.containsKey(owner)) {
            this.messages.put(owner, new ArrayList());
        }
        this.messages.get(owner).add(userMessage);
    }

    @Override
    public void okMessage(Object owner, final int messageId) {
        if (this.messages.containsKey(owner)) {
            Iterables.removeIf((Iterable)this.messages.get(owner), (Predicate)new Predicate<UserMessage>(){

                public boolean apply(UserMessage message) {
                    return message.messageId == messageId;
                }
            });
        }
        this.logNextMessage();
    }

    public Optional<UserMessage> nextMessage() {
        Collection<List<UserMessage>> values = this.messages.values();
        Iterable concat = Iterables.concat(values);
        LinkedList messageList = Lists.newLinkedList((Iterable)concat);
        if (messageList.isEmpty()) {
            return Optional.absent();
        }
        Collections.sort(messageList);
        return Optional.of((Object)((UserMessage)messageList.get(0)));
    }

    private void logNextMessage() {
        Optional<UserMessage> nextMessage = this.nextMessage();
        if (nextMessage.isPresent()) {
            ((UserMessage)nextMessage.get()).log();
        } else {
            this.setMessage("There are no errors.", 0);
        }
    }

    private class UserMessage
    implements Comparable<UserMessage> {
        private int type;
        private String message;
        private int messageId;

        public UserMessage(int type, String message, int messageId) {
            this.type = type;
            this.message = message;
            this.messageId = messageId;
        }

        void log() {
            TitleAreaEditorDialog.this.setMessage(this.message, this.type);
        }

        @Override
        public int compareTo(UserMessage o) {
            return Integer.compare(this.type, o.type);
        }
    }
}

