/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.dialog;

import java.lang.reflect.Constructor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.ui.widgets.WidgetsActivator;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class SimpleEditorDialog<T extends Composite>
extends Dialog {
    private Point size;
    private Class<T> editorClazz;
    private ISimpleDialogEditorPresenter<T> controller;
    private T editor;
    private boolean done = false;
    private String okLabel = IDialogConstants.OK_LABEL;
    private String cancelLabel = IDialogConstants.CANCEL_LABEL;
    private String title;
    private String backLabel;

    public SimpleEditorDialog(Shell parentShell, Class<T> editor, ISimpleDialogEditorPresenter<T> controller) {
        super(parentShell);
        this.editorClazz = editor;
        this.controller = controller;
    }

    public SimpleEditorDialog<T> setOkLabel(String okLabel) {
        this.okLabel = okLabel;
        return this;
    }

    public SimpleEditorDialog<T> setCancelLabel(String cancelLabel) {
        this.cancelLabel = cancelLabel;
        return this;
    }

    public SimpleEditorDialog<T> setBackButton(String backLabel) {
        this.backLabel = backLabel;
        return this;
    }

    protected Control createDialogArea(Composite parent) {
        try {
            if (this.title != null) {
                this.getShell().setText(this.title);
            }
            Constructor<T> constructor = this.editorClazz.getConstructor(Composite.class, Integer.TYPE);
            this.editor = (Composite)constructor.newInstance(parent, 0);
            this.editor.setLayoutData((Object)new GridData(4, 4, true, true));
            this.controller.handle(this.editor);
            return this.editor;
        }
        catch (Exception e) {
            WidgetsActivator.logError("Error while creating dialog", e);
            return parent;
        }
    }

    protected Control createButtonBar(Composite parent) {
        if (this.backLabel != null) {
            Composite toolbar = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)toolbar);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(toolbar);
            Composite leftToolbar = this.createButtonBarComposite(toolbar);
            Button previousButton = this.createButton(leftToolbar, 14, this.backLabel, true);
            GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)previousButton);
            Composite rightToolbar = new Composite(toolbar, 0);
            GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)rightToolbar);
            GridLayoutFactory.fillDefaults().applyTo(rightToolbar);
            return super.createButtonBar(rightToolbar);
        }
        return super.createButtonBar(parent);
    }

    private Composite createButtonBarComposite(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        Composite leftToolbar = new Composite(parent, 0);
        leftToolbar.setLayout((Layout)layout);
        GridDataFactory.swtDefaults().align(1, 0x1000000);
        return leftToolbar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.okLabel, true);
        this.createButton(parent, 1, this.cancelLabel, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 14) {
            this.setReturnCode(buttonId);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public T getEditor() {
        return this.editor;
    }

    protected void okPressed() {
        boolean onSave = this.controller.onSave();
        if (onSave) {
            this.done = true;
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        boolean onCancel = this.controller.onCancel();
        if (onCancel) {
            this.done = true;
            super.cancelPressed();
        }
    }

    public boolean close() {
        if (!this.done) {
            this.controller.onCancel();
        }
        return super.close();
    }

    public int open() {
        WidgetUtils.applyDialogWorkaroundForMacOS(this);
        return super.open();
    }

    protected Point getInitialSize() {
        if (this.size != null) {
            return this.size;
        }
        return super.getInitialSize();
    }

    protected boolean isResizable() {
        return true;
    }

    public void setSize(Point size) {
        this.size = size;
    }

    public void setSize(int width, int height) {
        this.size = new Point(width, height);
    }

    public void setTitle(String text) {
        this.title = text;
    }
}

