/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.dialog;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.ui.widgets.WidgetsActivator;

public class MessageDialogWithProgress
extends MessageDialog {
    private ProgressMonitorPart progress;
    private IRunnableWithProgress runnable;
    private String actionTitle;

    public MessageDialogWithProgress(Shell parentShell, IRunnableWithProgress runnable, String title, String message, String actionTitle) {
        super(parentShell, title, null, message, 3, new String[]{"Yes", "No"}, 0);
        this.runnable = runnable;
        this.actionTitle = actionTitle;
    }

    protected Control createDialogArea(Composite parent) {
        Composite createDialogArea = (Composite)super.createDialogArea(parent);
        this.progress = new ProgressMonitorPart(createDialogArea, (Layout)GridLayoutFactory.fillDefaults().create(), true){

            protected void updateLabel() {
                if (Display.getCurrent() != null) {
                    super.updateLabel();
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            this.updateLabel();
                        }
                    });
                }
            }
        };
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.progress);
        return createDialogArea;
    }

    protected void buttonPressed(int buttonId) {
        block6: {
            if (buttonId == 0) {
                try {
                    try {
                        this.progress.beginTask(this.actionTitle + "...", 100);
                        this.progress.worked(10);
                        this.runnable.run((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.progress, 80));
                        this.progress.worked(10);
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        String message = "There was a problem " + StringUtils.uncapitalize((String)this.actionTitle);
                        MessageDialog.openError((Shell)this.getShell(), (String)this.getShell().getText(), (String)message);
                        WidgetsActivator.logError(message, e);
                        this.progress.done();
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.progress.done();
                    throw throwable;
                }
                this.progress.done();
            }
        }
        super.okPressed();
    }
}

