/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.dialog;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.ui.widgets.dialog.IEditorMessageLogger;

public class EditorMessageLogger
extends Composite
implements IEditorMessageLogger {
    private CLabel label;
    private Map<Object, List<UserMessage>> messages = new HashMap<Object, List<UserMessage>>();

    public EditorMessageLogger(Composite parent, int style) {
        super(parent, style);
        this.setVisible(true);
        this.setLayout((Layout)new FillLayout(256));
        this.label = new CLabel((Composite)this, 16384);
        this.label.setBackground(Display.getCurrent().getSystemColor(1));
        this.label.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Color foreground = Display.getCurrent().getSystemColor(18);
                Color background = Display.getCurrent().getSystemColor(25);
                e.gc.setForeground(foreground);
                e.gc.drawLine(0, EditorMessageLogger.this.getBounds().height - 2, EditorMessageLogger.this.getBounds().width, EditorMessageLogger.this.getBounds().height - 2);
                e.gc.setBackground(background);
                e.gc.drawLine(0, EditorMessageLogger.this.getBounds().height - 2, EditorMessageLogger.this.getBounds().width, EditorMessageLogger.this.getBounds().height - 2);
                e.gc.dispose();
            }
        });
        this.updateMessage();
    }

    private void updateMessage() {
    }

    private String wrap(String message) {
        String lineSeparator = System.getProperty("line.separator");
        if (((String)message).contains(lineSeparator)) {
            message = ((String)message).replaceAll(lineSeparator, " ");
        }
        if (!((String)message).trim().isEmpty() && ((String)message).length() > 80) {
            message = ((String)message).substring(0, 80) + "...";
        }
        return message;
    }

    public String getText() {
        return this.label.getText();
    }

    @Override
    public void errorMessage(Object owner, String logMessage, int messageId) {
        UserMessage userMessage = new UserMessage(3, logMessage, messageId);
        this.addMessage(owner, userMessage);
        this.logNextMessage();
    }

    @Override
    public void warningMessage(Object owner, String logMessage, int messageId) {
        UserMessage userMessage = new UserMessage(2, logMessage, messageId);
        this.addMessage(owner, userMessage);
        this.logNextMessage();
    }

    private void addMessage(Object owner, UserMessage userMessage) {
        if (!this.messages.containsKey(owner)) {
            this.messages.put(owner, new ArrayList());
        }
        this.messages.get(owner).add(userMessage);
    }

    @Override
    public void okMessage(Object owner, final int messageId) {
        if (this.messages.containsKey(owner)) {
            Iterables.removeIf((Iterable)this.messages.get(owner), (Predicate)new Predicate<UserMessage>(){

                public boolean apply(UserMessage message) {
                    return message.messageId == messageId;
                }
            });
        }
        this.logNextMessage();
    }

    private void logNextMessage() {
        Optional<UserMessage> nextMessage = this.nextMessage();
        if (nextMessage.isPresent()) {
            ((UserMessage)nextMessage.get()).log();
        } else {
            this.setMessage("There are no errors.", 0);
        }
    }

    public Optional<UserMessage> nextMessage() {
        Collection<List<UserMessage>> values = this.messages.values();
        Iterable concat = Iterables.concat(values);
        LinkedList messageList = Lists.newLinkedList((Iterable)concat);
        if (messageList.isEmpty()) {
            return Optional.absent();
        }
        Collections.sort(messageList);
        return Optional.of((Object)((UserMessage)messageList.get(0)));
    }

    public void setMessage(String message, int type) {
        this.label.setText(this.wrap(message));
        this.label.layout();
    }

    private class UserMessage
    implements Comparable<UserMessage> {
        private int type;
        private String message;
        private int messageId;

        public UserMessage(int type, String message, int messageId) {
            this.type = type;
            this.message = message;
            this.messageId = messageId;
        }

        void log() {
            EditorMessageLogger.this.setMessage(this.message, this.type);
        }

        @Override
        public int compareTo(UserMessage o) {
            return Integer.compare(this.type, o.type);
        }
    }
}

