/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.dialog;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.ui.widgets.dialog.MsgBoxButton;

public class CustomMessageBox {
    public static final String CANCEL = "Cancel";
    public static final String OK = "Ok";
    private String title;
    private Shell display;
    private List<MsgBoxButton> buttons = new ArrayList<MsgBoxButton>();
    private String content;
    private MessageDialog messageDialog;

    public CustomMessageBox(Shell display, String title, String content) {
        this.title = title;
        this.display = display;
        this.content = content;
    }

    public CustomMessageBox addButton(MsgBoxButton button) {
        this.buttons.add(button);
        return this;
    }

    public CustomMessageBox create(int dialogType, int defaultSelectedButton) {
        ArrayList buttonsList = Lists.newArrayList((Iterable)Iterables.transform(this.buttons, (Function)new Function<MsgBoxButton, String>(){

            public String apply(MsgBoxButton input) {
                return input.getText();
            }
        }));
        String[] buttonStrings = buttonsList.toArray(new String[buttonsList.size()]);
        this.messageDialog = new MessageDialog(this.display, this.title, null, this.content, dialogType, buttonStrings, defaultSelectedButton);
        return this;
    }

    public int open() {
        int result = this.messageDialog.open();
        try {
            MsgBoxButton buttonToExecute = this.buttons.get(result);
            buttonToExecute.execute();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return result;
    }
}

