/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.cssHandler;

import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.ControlElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.widgets.SquareButton;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class FlatButtonCssHandler
implements ICSSPropertyHandler {
    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        ControlElement ctrlElement;
        if (element instanceof ControlElement && this.mustStyleButton(ctrlElement = (ControlElement)element)) {
            this.styleFlatButton((SquareButton)((Object)ctrlElement.getNativeWidget()), property, value, pseudo, engine);
            return true;
        }
        return false;
    }

    private void styleFlatButton(SquareButton button, String property, CSSValue value, String pseudo, CSSEngine engine) {
        Display display = button.getDisplay();
        if ("fbtn-selected-color".equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            button.setSelectedColors(swtColor, swtColor, button.getBackground(), null);
        } else if ("fbtn-border-width".equals(property)) {
            int pixelValue = (int)((CSSPrimitiveValue)value).getFloatValue((short)9);
            button.setBorderWidth(pixelValue);
        } else if ("fbtn-inactive-color".equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            button.setInactiveColors(swtColor, swtColor, button.getBackground(), null);
        } else if ("fbtn-hover-color".equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            button.setHoverColors(swtColor, swtColor, button.getBackground(), null);
        } else if ("fbtn-default-color".equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            button.setDefaultColors(swtColor, swtColor, button.getBackground(), null);
        } else if ("fbtn-clicked-color".equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            button.setClickedColors(swtColor, swtColor, button.getBackground(), null);
        } else if ("fbtn-border-color".equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            button.setBorderColor(swtColor);
        } else if ("fbtn-clicked-border-color".equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            button.setClickedBorderColor(swtColor);
        } else if ("fbtn-border-alpha".equals(property)) {
            int pixelValue = (int)((CSSPrimitiveValue)value).getFloatValue((short)9);
            button.setBorderAlpha(pixelValue);
        } else if ("fbtn-font-color".equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            button.setFontColor(swtColor);
        } else if ("fbtn-selected-font-color".equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            button.setSelectedFontColor(swtColor);
        }
    }

    private boolean mustStyleButton(ControlElement element) {
        return element.getNativeWidget() instanceof SquareButton;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

