/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.cssHandler;

import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.ControlElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.widgets.tab.TabbedPropertyList;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.w3c.dom.css.CSSValue;

public class CustomTabsCssHandler
implements ICSSPropertyHandler {
    private static final String SELECTION_LINE_RIGHT = "selection-line-right";
    private static final String TOP_ELEMENT_HEIGHT = "top-element-height";
    private static final String TAB_WIDTH = "tab-width";
    private static final String CUSTOM_SIZE = "custom-size";
    private static final String CUSTOM_HEIGHT = "custom-height";
    private static final String HOVER_GRADIENT_END = "hover-gradient-end";
    private static final String HOVER_GRADIENT_START = "hover-gradient-start";
    private static final String DEFAULT_GRADIENT_END = "default-gradient-end";
    private static final String DEFAULT_GRADIENT_START = "default-gradient-start";
    private static final String LIST_BACKGROUND = "list-background";
    private static final String BACKGROUND_COLOR = "background-color";
    private static final String HOVER_COLOR = "hover-color";
    private static final String SELECTED_COLOR = "selected-color";
    private static final String COLOR = "color";
    private static final String UNSELECTED_COLOR = "unselected-color";

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (element instanceof ControlElement) {
            ControlElement ctrlElement = (ControlElement)element;
            if (this.mustStyleTab(ctrlElement)) {
                this.styleTabbedPropertyList((TabbedPropertyList)((Object)ctrlElement.getNativeWidget()), property, value, pseudo, engine);
                return true;
            }
            if (ctrlElement.getNativeWidget() instanceof TabbedPropertyList.ListElement) {
                this.styleListElement((TabbedPropertyList.ListElement)((Object)ctrlElement.getNativeWidget()), property, value, pseudo, engine);
            }
        }
        return false;
    }

    private void styleListElement(TabbedPropertyList.ListElement listElement, String property, CSSValue value, String pseudo, CSSEngine engine) {
        Display display = listElement.getDisplay();
        if (COLOR.equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            listElement.setImageOnHoverColor(swtColor);
        }
    }

    private void styleTabbedPropertyList(TabbedPropertyList nativeWidget, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Display display = nativeWidget.getDisplay();
        if (UNSELECTED_COLOR.equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            nativeWidget.setWidgetForeground(swtColor);
        } else if (SELECTED_COLOR.equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            nativeWidget.setSelectedWidgetForeground(swtColor);
        } else if (HOVER_COLOR.equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            nativeWidget.setHoverWidgetForeground(swtColor);
        } else if (BACKGROUND_COLOR.equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            nativeWidget.setWidgetBackground(swtColor);
        } else if (LIST_BACKGROUND.equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            nativeWidget.setListBackground(swtColor);
        } else if (DEFAULT_GRADIENT_START.equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            nativeWidget.setDefaultGradientStart(swtColor);
        } else if (DEFAULT_GRADIENT_END.equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            nativeWidget.setDefaultGradientEnd(swtColor);
        } else if (HOVER_GRADIENT_START.equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            nativeWidget.setHoverGradientStart(swtColor);
        } else if (HOVER_GRADIENT_END.equals(property)) {
            Color swtColor = ThemeUtils.cssValueToColor(value, engine, display);
            nativeWidget.setHoverGradientEnd(swtColor);
        } else if (CUSTOM_SIZE.equals(property)) {
            boolean customSized = (Boolean)engine.convert(value, Boolean.class, null);
            nativeWidget.setCustomSize(customSized);
        } else if (TAB_WIDTH.equals(property)) {
            int tabSize = Integer.parseInt(value.getCssText());
            nativeWidget.setCustomWidth(tabSize);
        } else if (TOP_ELEMENT_HEIGHT.equals(property)) {
            int topElementHeight = Integer.parseInt(value.getCssText());
            nativeWidget.setTopElementHeight(topElementHeight);
        } else if (SELECTION_LINE_RIGHT.equals(property)) {
            boolean isSelectionLineOnTheRight = (Boolean)engine.convert(value, Boolean.class, null);
            nativeWidget.setSelectedLineRight(isSelectionLineOnTheRight);
        } else if (CUSTOM_HEIGHT.equals(property)) {
            int heightHint = Integer.parseInt(value.getCssText());
            nativeWidget.setTabItemHeight(heightHint);
        }
    }

    private boolean mustStyleTab(ControlElement ctrlElement) {
        return ctrlElement.getNativeWidget() instanceof TabbedPropertyList;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

