/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.button;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RadioButtonGroup
extends Composite {
    private LinkedHashMap<String, Row> rows;
    private Consumer<Button> onButtonSelected;

    public RadioButtonGroup(Composite parent, Consumer<Button> onButtonSelected) {
        super(parent, 0);
        this.setLayout(GridLayoutFactory.fillDefaults().margins(5, 5).spacing(0, 0).create());
        this.rows = Maps.newLinkedHashMap();
        this.onButtonSelected = onButtonSelected;
    }

    private Collection<Button> getButtons() {
        ArrayList buttons = Lists.newArrayList();
        for (Row row : this.rows.values()) {
            buttons.add(row.getRadioButton());
        }
        return buttons;
    }

    private Button getButton(String label) {
        return this.rows.get(label).getRadioButton();
    }

    public void setLayout(GridLayout layout) {
        super.setLayout((Layout)layout);
    }

    public void setLayoutData(Object layoutData) {
        super.setLayoutData(layoutData);
    }

    public void setButtonsLayoutData(GridData layoutData) {
        for (Button button : this.getButtons()) {
            button.setLayoutData((Object)layoutData);
        }
    }

    public Button addButton(String label) {
        return this.addRow(label, new NullCompositesFactory()).getRadioButton();
    }

    public Row addRow(String label, ControlsFactory factory) {
        Composite rowComposite = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)rowComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(rowComposite);
        Button button = new Button(rowComposite, 16);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button radioButton = (Button)e.getSource();
                RadioButtonGroup.this.onButtonSelected.accept(radioButton);
                RadioButtonGroup.this.setSelectedButton(radioButton.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        button.setText(label);
        GridDataFactory.fillDefaults().applyTo((Control)button);
        Map<String, Control> additionalControls = factory.create(rowComposite);
        Row row = new Row(rowComposite, button, additionalControls);
        this.rows.put(label, row);
        this.adjustLayout(rowComposite, row);
        return row;
    }

    public Row getRow(String label) {
        return this.rows.get(label);
    }

    public Button setSelectedButton(String label) {
        for (Row row : this.rows.values()) {
            Button button = row.getRadioButton();
            boolean isSelected = button.getText().equals(label);
            button.setSelection(isSelected);
            Collection<Control> childControls = row.getChildControls();
            for (Control control : childControls) {
                control.setEnabled(isSelected);
            }
        }
        Button selectedButton = this.getButton(label);
        return selectedButton;
    }

    public Optional<String> getSelectedButton() {
        Collection<Button> buttons = this.getButtons();
        for (Button button : buttons) {
            if (!button.getSelection()) continue;
            return Optional.of((Object)button.getText());
        }
        return Optional.absent();
    }

    private void adjustLayout(Composite rowComposite, Row row) {
        GridLayoutFactory defaultLayout = GridLayoutFactory.swtDefaults();
        defaultLayout.numColumns(row.size()).applyTo(rowComposite);
    }

    public static interface ControlsFactory {
        public Map<String, Control> create(Composite var1);
    }

    public static final class NullCompositesFactory
    implements ControlsFactory {
        @Override
        public Map<String, Control> create(Composite parent) {
            return Maps.newHashMap();
        }
    }

    public static class Row {
        private Button button;
        private Map<String, Control> controls;
        private Composite rowComposite;

        public Row(Composite rowComposite, Button button, Map<String, Control> controls) {
            this.rowComposite = rowComposite;
            this.button = button;
            this.controls = controls;
        }

        public Button getRadioButton() {
            return this.button;
        }

        public <T extends Control> T getChildControl(String label) {
            return (T)this.controls.get(label);
        }

        public Collection<Control> getChildControls() {
            return this.controls.values();
        }

        public int size() {
            return this.controls.size() + 1;
        }

        public Composite getRowComposite() {
            return this.rowComposite;
        }
    }
}

