/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.button;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.listener.ICollapseListener;

public class CollapseButton
extends ImageFigure {
    private Image collapseImg;
    private Image expandImg;
    private boolean collapsed;
    private List<ICollapseListener> collapseListeners = Lists.newArrayList();
    private Image collapseImgBold;
    private Image expandImgBold;
    private static final Map<String, Runnable> collapseButtonDrawer = new HashMap<String, Runnable>();

    private void init() {
        collapseButtonDrawer.put("org.mule.tooling.category.scopes", () -> this.setBlueImages());
        collapseButtonDrawer.put("org.mule.tooling.ui.modules.core.exceptions", () -> this.setRedImages());
        collapseButtonDrawer.put("org.mule.tooling.category.munit", () -> this.setGreenImages());
    }

    public CollapseButton(boolean isCollapsedByDefault, String categoryId) {
        this.collapsed = isCollapsedByDefault;
        this.setImage(isCollapsedByDefault, false);
        this.addMouseListener(new CollapseButtonMouseListener());
        this.addMouseMotionListener(new CollapseButtonMouseMotionListener());
        this.init();
        collapseButtonDrawer.getOrDefault(categoryId, () -> this.setGreyImages()).run();
        this.setImage(isCollapsedByDefault, false);
    }

    public CollapseButton(boolean isCollapsedByDefault, String categoryId, boolean isErrorHandler) {
        this(isCollapsedByDefault, isErrorHandler ? "org.mule.tooling.ui.modules.core.exceptions" : categoryId);
    }

    private void setGreyImages() {
        this.collapseImg = WidgetsImages.getImage("icons/collapse-arrow-open-grey.png");
        this.expandImg = WidgetsImages.getImage("icons/collapse-arrow-closed-grey.png");
        this.collapseImgBold = WidgetsImages.getImage("icons/collapse-arrow-open.png");
        this.expandImgBold = WidgetsImages.getImage("icons/collapse-arrow-closed.png");
    }

    private void setBlueImages() {
        this.collapseImg = WidgetsImages.getImage("icons/collapse-arrow-open-blue.png");
        this.expandImg = WidgetsImages.getImage("icons/collapse-arrow-closed-blue.png");
        this.collapseImgBold = WidgetsImages.getImage("icons/collapse-arrow-open-hover-blue.png");
        this.expandImgBold = WidgetsImages.getImage("icons/collapse-arrow-closed-hover-blue.png");
    }

    private void setRedImages() {
        this.collapseImg = WidgetsImages.getImage("icons/collapse-arrow-open-red.png");
        this.expandImg = WidgetsImages.getImage("icons/collapse-arrow-closed-red.png");
        this.collapseImgBold = WidgetsImages.getImage("icons/collapse-arrow-open-hover-red.png");
        this.expandImgBold = WidgetsImages.getImage("icons/collapse-arrow-closed-hover-red.png");
    }

    private void setGreenImages() {
        this.collapseImg = WidgetsImages.getImage("icons/collapse-arrow-open-green.png");
        this.expandImg = WidgetsImages.getImage("icons/collapse-arrow-closed-green.png");
        this.collapseImgBold = WidgetsImages.getImage("icons/collapse-arrow-open-hover-green.png");
        this.expandImgBold = WidgetsImages.getImage("icons/collapse-arrow-closed-hover-green.png");
    }

    public CollapseButton(boolean isCollapsedByDefault, Image collapseImg, Image expandImg, Image collapseImgBold, Image expandImgBold) {
        this.collapsed = isCollapsedByDefault;
        this.collapseImg = collapseImg;
        this.expandImg = expandImg;
        this.collapseImgBold = collapseImgBold;
        this.expandImgBold = expandImgBold;
        this.setImage(isCollapsedByDefault, false);
        this.addMouseListener(new CollapseButtonMouseListener());
        this.addMouseMotionListener(new CollapseButtonMouseMotionListener());
    }

    private void setImage(boolean collapsed, boolean bold) {
        if (collapsed) {
            if (bold) {
                this.setImage(this.expandImgBold);
            } else {
                this.setImage(this.expandImg);
            }
        } else if (bold) {
            this.setImage(this.collapseImgBold);
        } else {
            this.setImage(this.collapseImg);
        }
    }

    public void addListener(ICollapseListener listener) {
        this.collapseListeners.add(listener);
    }

    public void removeListeners() {
        this.collapseListeners.clear();
    }

    private void doCollapse() {
        this.setImage(this.expandImg);
        this.collapsed = !this.collapsed;
        for (ICollapseListener listener : this.collapseListeners) {
            listener.onCollapse();
        }
    }

    private void doExpand() {
        this.setImage(this.collapseImg);
        this.collapsed = !this.collapsed;
        for (ICollapseListener listener : this.collapseListeners) {
            listener.onExpand();
        }
    }

    public void reset() {
        this.collapsed = !this.collapsed;
        this.setImage(this.collapsed, false);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    private class CollapseButtonMouseListener
    implements MouseListener {
        private CollapseButtonMouseListener() {
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            if (CollapseButton.this.collapsed) {
                CollapseButton.this.doExpand();
            } else {
                CollapseButton.this.doCollapse();
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }

    private final class CollapseButtonMouseMotionListener
    implements MouseMotionListener {
        private CollapseButtonMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
            CollapseButton.this.setImage(CollapseButton.this.collapsed, false);
        }

        public void mouseEntered(MouseEvent me) {
            CollapseButton.this.setImage(CollapseButton.this.collapsed, true);
        }

        public void mouseDragged(MouseEvent me) {
        }
    }
}

