/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.mule.tooling.ui.widgets.action.DisposableAction;

public class DropdownAction
extends DisposableAction {
    private ArrayList<Action> actions;
    private Menu menu;

    public DropdownAction(String text, Control parent) {
        super(text, 4);
        this.setActions(new ArrayList<Action>());
        this.createMenu(parent);
    }

    @Override
    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    protected void createMenu(Control parent) {
        this.setMenu(new Menu(parent));
        final Listener onClickListener = event -> {
            boolean bl = parent.setFocus();
        };
        this.getMenu().addListener(3, onClickListener);
        this.getMenu().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DropdownAction.this.getMenu().removeListener(3, onClickListener);
                DropdownAction.this.getMenu().removeDisposeListener((DisposeListener)this);
            }
        });
    }

    public DropdownAction(String text, ImageDescriptor imageDescriptor, Control parent) {
        this(text, parent);
        this.setImageDescriptor(imageDescriptor);
    }

    public void addAll(List<Action> actions) {
        for (Action action : actions) {
            this.addAction(action);
        }
    }

    public void addAction(Action action) {
        this.getActions().add(action);
        this.createMenuItem(action);
    }

    protected MenuItem createMenuItem(Action action) {
        return this.createMenuItem(action, 0);
    }

    protected MenuItem createMenuItem(Action action, int style) {
        MenuItem menuItem = new MenuItem(this.getMenu(), style);
        menuItem.setText(action.getText());
        ImageDescriptor imageDescriptor = action.getImageDescriptor();
        if (imageDescriptor != null) {
            menuItem.setImage(imageDescriptor.createImage());
        }
        IPropertyChangeListener propertyChangedListener = this.createMenuItemEnableListener(action, menuItem);
        SelectionAdapter selectionListener = this.createMenuItemSelectionListener(action);
        action.addPropertyChangeListener(propertyChangedListener);
        menuItem.addSelectionListener((SelectionListener)selectionListener);
        menuItem.addDisposeListener(this.createMenuItemDisposeListener(action, menuItem, propertyChangedListener, (SelectionListener)selectionListener));
        menuItem.setEnabled(action.isEnabled());
        return menuItem;
    }

    protected DisposeListener createMenuItemDisposeListener(final Action action, final MenuItem menuItem, final IPropertyChangeListener propertyChangedListener, final SelectionListener selectionListener) {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                action.removePropertyChangeListener(propertyChangedListener);
                menuItem.removeSelectionListener(selectionListener);
                menuItem.removeDisposeListener((DisposeListener)this);
            }
        };
    }

    protected IPropertyChangeListener createMenuItemEnableListener(Action action, MenuItem menuItem) {
        return event -> {
            if (event.getProperty().equals("enabled")) {
                menuItem.setEnabled(action.isEnabled());
            }
        };
    }

    protected SelectionAdapter createMenuItemSelectionListener(final Action action) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DropdownAction.this.onActionSelected(action);
            }
        };
    }

    protected void onActionSelected(Action action) {
        action.run();
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem item = (ToolItem)event.widget;
            ToolBar toolBar = item.getParent();
            Rectangle rect = item.getBounds();
            Point point = toolBar.toDisplay(new Point(rect.x, rect.height));
            this.getMenu().setLocation(point.x, point.y);
            this.getMenu().setVisible(true);
        }
    }

    public ArrayList<Action> getActions() {
        return this.actions;
    }

    public void setActions(ArrayList<Action> actions) {
        this.actions = actions;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }
}

