/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.ui.widgets.WidgetsImages;

public class ValidationWidgetStatus {
    private final long validationTime;
    private final String tooltip;
    private final Image image;

    private ValidationWidgetStatus(long validationTime, String tooltip, Image image) {
        this.validationTime = validationTime;
        this.tooltip = tooltip;
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public long getValidationTime() {
        return this.validationTime;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public static ValidationWidgetStatus create(int status, long validationTime, String tooltip) {
        if (status == 1) {
            return ValidationWidgetStatus.createInfo(validationTime, tooltip);
        }
        if (status == 0) {
            return new ValidationWidgetStatus(validationTime, tooltip, WidgetsImages.getImage("icons/requirements/success.png"));
        }
        if (status == 2) {
            return new ValidationWidgetStatus(validationTime, tooltip, WidgetsImages.getImage("icons/requirements/help.png"));
        }
        return ValidationWidgetStatus.createError(validationTime, tooltip);
    }

    public static ValidationWidgetStatus createInfo(long validationTime, String tooltip) {
        return new ValidationWidgetStatus(validationTime, tooltip, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
    }

    public static ValidationWidgetStatus createError(long validationTime, String tooltip) {
        return new ValidationWidgetStatus(validationTime, tooltip, WidgetsImages.getImage("icons/requirements/error.png"));
    }
}

