/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class SquareButton
extends Canvas {
    protected Listener keyListener;
    protected Image image;
    protected Image backgroundImage;
    protected String text;
    protected Font font;
    protected Color fontColor;
    protected Color hoverFontColor;
    protected Color clickedFontColor;
    protected Color inactiveFontColor;
    protected Color selectedFontColor;
    protected Color borderColor;
    protected Color hoverBorderColor;
    protected Color clickedBorderColor;
    protected Color inactiveBorderColor;
    protected Color selectedBorderColor;
    protected Color currentColor;
    protected Color currentColor2;
    protected Color currentFontColor;
    protected Color currentBorderColor;
    protected Color backgroundColor;
    protected Color backgroundColor2;
    protected Color clickedColor;
    protected Color clickedColor2;
    protected Color hoverColor;
    protected Color hoverColor2;
    protected Color inactiveColor;
    protected Color inactiveColor2;
    protected Color selectedColor;
    protected Color selectedColor2;
    protected int anchorWidth = 4;
    protected int innerMarginWidth = 8;
    protected int innerMarginHeight = 4;
    protected int borderWidth = 1;
    protected int imagePadding = 5;
    protected boolean enabled = true;
    protected boolean roundedCorners = true;
    protected boolean squareCornesWithAnchor = false;
    protected boolean isFocused = false;
    protected boolean selectionBorder = false;
    private int lastWidth;
    private int lastHeight;
    public static int BG_IMAGE_CROP = 0;
    public static int BG_IMAGE_STRETCH = 1;
    public static int BG_IMAGE_TILE = 2;
    public static int BG_IMAGE_CENTER = 3;
    public static int BG_IMAGE_FIT = 4;
    protected int backgroundImageStyle = 0;
    public static int IMAGE_LEFT = 0;
    public static int IMAGE_RIGHT = 1;
    protected int imageStyle = 0;
    private boolean textOnCenter = true;
    private DisposeListener disposeListener;
    private PaintListener paintListener;
    private List<ListenerAndEventType> listeners = new ArrayList<ListenerAndEventType>();
    private int borderAlpha;

    public SquareButton(Composite parent, int style) {
        super(parent, style | 0x40000);
        this.setBackgroundMode(1);
        this.setDefaultColors();
        this.addListeners();
    }

    protected void widgetDisposed(DisposeEvent e) {
        this.removeDisposeListener(this.disposeListener);
        this.removePaintListener(this.paintListener);
        this.removeGenericListeners();
    }

    protected void addListeners() {
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SquareButton.this.widgetDisposed(e);
            }
        };
        this.addDisposeListener(this.disposeListener);
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                SquareButton.this.paintControl(e);
            }
        };
        this.addPaintListener(this.paintListener);
        ListenerAndEventType mouseEnterListener = new ListenerAndEventType(6, new Listener(){

            public void handleEvent(Event e) {
                SquareButton.this.setHoverColor(e);
            }
        });
        this.listeners.add(mouseEnterListener);
        ListenerAndEventType mouseExitListener = new ListenerAndEventType(7, new Listener(){

            public void handleEvent(Event e) {
                if (SquareButton.this.isFocused) {
                    SquareButton.this.setSelectedColor(e);
                } else {
                    SquareButton.this.setNormalColor(e);
                }
            }
        });
        this.listeners.add(mouseExitListener);
        ListenerAndEventType mouseUpListener = new ListenerAndEventType(4, new Listener(){

            public void handleEvent(Event e) {
                if (e.button == 1) {
                    SquareButton.this.setHoverColor(e);
                    if (e.count == 1 && SquareButton.this.enabled && SquareButton.this.getClientArea().contains(e.x, e.y)) {
                        SquareButton.this.doButtonClicked();
                    }
                }
            }
        });
        this.listeners.add(mouseUpListener);
        ListenerAndEventType mouseHoverListener = new ListenerAndEventType(32, new Listener(){

            public void handleEvent(Event e) {
                SquareButton.this.setHoverColor(e);
            }
        });
        this.listeners.add(mouseHoverListener);
        ListenerAndEventType mouseDownListener = new ListenerAndEventType(3, new Listener(){

            public void handleEvent(Event e) {
                if (e.button == 1) {
                    SquareButton.this.setClickedColor(e);
                }
            }
        });
        this.listeners.add(mouseDownListener);
        ListenerAndEventType traverseListener = new ListenerAndEventType(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        e.doit = true;
                    }
                }
            }
        });
        this.listeners.add(traverseListener);
        ListenerAndEventType focusInListener = new ListenerAndEventType(15, new Listener(){

            public void handleEvent(Event e) {
                SquareButton.this.isFocused = true;
                SquareButton.this.setSelectedColor(e);
                SquareButton.this.redraw();
            }
        });
        this.listeners.add(focusInListener);
        ListenerAndEventType focusOutListener = new ListenerAndEventType(16, new Listener(){

            public void handleEvent(Event e) {
                SquareButton.this.isFocused = false;
                SquareButton.this.setNormalColor(e);
                SquareButton.this.redraw();
            }
        });
        this.listeners.add(focusOutListener);
        ListenerAndEventType keyUpListener = new ListenerAndEventType(2, new Listener(){

            public void handleEvent(Event e) {
                SquareButton.this.isFocused = true;
                SquareButton.this.setSelectedColor(e);
                SquareButton.this.redraw();
            }
        });
        this.listeners.add(keyUpListener);
        this.keyListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.character) {
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        SquareButton.this.setClickedColor(e);
                        SquareButton.this.redraw();
                        SquareButton.this.doButtonClicked();
                    }
                }
            }
        };
        this.setTraversable(true);
        this.addAllListeners();
    }

    private void addAllListeners() {
        for (ListenerAndEventType event : this.listeners) {
            this.addListener(event.getEventType(), event.getListener());
        }
    }

    private void removeGenericListeners() {
        for (ListenerAndEventType event : this.listeners) {
            this.removeListener(event.getEventType(), event.getListener());
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)listener));
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeListener(13, (SWTEventListener)listener);
    }

    protected void setTraversable(boolean canTraverse) {
        try {
            if (canTraverse) {
                this.addListener(1, this.keyListener);
            } else if (!canTraverse) {
                this.removeListener(1, this.keyListener);
            }
        }
        catch (Exception exception) {}
    }

    protected void doButtonClicked() {
        Event e = new Event();
        e.item = this;
        e.widget = this;
        e.type = 13;
        this.notifyListeners(13, e);
    }

    protected void setDefaultColors() {
        this.fontColor = this.getSavedColor(0, 0, 0);
        this.hoverFontColor = this.getSavedColor(0, 0, 0);
        this.clickedFontColor = this.getSavedColor(255, 255, 255);
        this.inactiveFontColor = this.getSavedColor(187, 187, 187);
        this.selectedFontColor = this.getSavedColor(160, 107, 38);
        this.borderColor = this.getSavedColor(204, 204, 204);
        this.hoverBorderColor = this.getSavedColor(147, 147, 147);
        this.clickedBorderColor = this.getSavedColor(147, 147, 147);
        this.inactiveBorderColor = this.getSavedColor(200, 200, 200);
        this.selectedBorderColor = this.getSavedColor(160, 107, 38);
        this.backgroundColor = this.getSavedColor(248, 248, 248);
        this.backgroundColor2 = this.getSavedColor(228, 228, 228);
        this.clickedColor = this.getSavedColor(120, 120, 120);
        this.clickedColor2 = this.getSavedColor(150, 150, 150);
        this.hoverColor = this.getSavedColor(248, 248, 248);
        this.hoverColor2 = this.getSavedColor(228, 228, 228);
        this.inactiveColor = this.getSavedColor(248, 248, 248);
        this.inactiveColor2 = this.getSavedColor(228, 228, 228);
        this.selectedColor = this.getSavedColor(238, 238, 238);
        this.selectedColor2 = this.getSavedColor(218, 218, 218);
    }

    protected Color getSavedColor(int r, int g, int b) {
        String colorString = "SB_DEFAULT:" + r + "-" + g + "-" + b;
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        if (!colorRegistry.hasValueFor(colorString)) {
            colorRegistry.put(colorString, new RGB(r, g, b));
        }
        return colorRegistry.get(colorString);
    }

    protected void setNormalColor(Event e) {
        this.setMouseEventColor(this.backgroundColor, this.backgroundColor2, this.borderColor, this.fontColor);
    }

    protected void setHoverColor(Event e) {
        this.setMouseEventColor(this.hoverColor, this.hoverColor2, this.hoverBorderColor, this.hoverFontColor);
    }

    protected void setClickedColor(Event e) {
        this.setMouseEventColor(this.clickedColor, this.clickedColor2, this.clickedBorderColor, this.clickedFontColor);
    }

    protected void setInactiveColor(Event e) {
        this.setMouseEventColor(this.inactiveColor, this.inactiveColor2, this.inactiveBorderColor, this.inactiveFontColor);
    }

    protected void setSelectedColor(Event e) {
        this.setMouseEventColor(this.selectedColor, this.selectedColor2, this.selectedBorderColor, this.selectedFontColor);
    }

    protected void setMouseEventColor(Color bgColor1, Color bgColor2, Color bdrColor, Color fntColor) {
        if (!this.enabled) {
            return;
        }
        if (this.currentColor == null) {
            this.currentColor = this.backgroundColor;
            this.currentColor2 = this.backgroundColor2;
            this.currentBorderColor = this.borderColor;
            this.currentFontColor = this.fontColor;
        }
        boolean redrawFlag = false;
        if (bgColor1 != null && !this.currentColor.equals((Object)bgColor1)) {
            this.currentColor = this.currentColor2 = bgColor1;
            if (bgColor2 != null) {
                this.currentColor2 = bgColor2;
            }
            redrawFlag = true;
        }
        if (bdrColor != null && !this.currentBorderColor.equals((Object)bdrColor)) {
            this.currentBorderColor = bdrColor;
            redrawFlag = true;
        }
        if (fntColor != null && !this.currentFontColor.equals((Object)fntColor)) {
            this.currentFontColor = fntColor;
            redrawFlag = true;
        }
        if (redrawFlag) {
            this.redraw();
        }
    }

    protected void paintControl(PaintEvent e) {
        if (this.currentColor == null) {
            this.currentColor = this.backgroundColor;
            this.currentColor2 = this.backgroundColor2;
            this.currentBorderColor = this.borderColor;
            this.currentFontColor = this.fontColor;
        }
        int x = this.innerMarginWidth + 1;
        int y = this.innerMarginHeight;
        Point p = this.computeSize(-1, -1, false);
        if (p.x > this.getClientArea().width) {
            p.x = this.getClientArea().width;
        }
        Rectangle rect = new Rectangle(0, 0, p.x, p.y);
        GC gc = e.gc;
        gc.setAntialias(1);
        gc.setAdvanced(true);
        if (!this.squareCornesWithAnchor) {
            gc.setBackground(this.getParent().getBackground());
            gc.fillRectangle(rect);
        }
        gc.setForeground(this.currentColor);
        gc.setBackground(this.currentColor2);
        Rectangle fill = new Rectangle(rect.x + 1, rect.y + 1, rect.width - 1, rect.height - 1);
        if (this.roundedCorners) {
            fill = new Rectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 3);
        }
        if (this.squareCornesWithAnchor) {
            int[] polygon = this.createAnchorPolygon(rect);
            gc.fillPolygon(polygon);
        } else {
            gc.fillGradientRectangle(fill.x, fill.y, fill.width, fill.height, true);
        }
        this.drawBackgroundImage(gc, fill);
        gc.setLineStyle(1);
        int arcHeight = Math.max(5, p.y / 10);
        int arcWidth = arcHeight++;
        int bw = this.borderWidth;
        if (this.borderWidth > 0) {
            gc.setLineWidth(this.borderWidth);
            gc.setForeground(this.currentBorderColor);
            gc.setAlpha(255);
        } else {
            bw = 1;
            gc.setLineWidth(1);
            gc.setForeground(this.getParent().getBackground());
            arcWidth = arcHeight;
        }
        gc.setAlpha(this.borderAlpha);
        if (this.roundedCorners) {
            gc.drawRoundRectangle(rect.x + (bw - 1), rect.y + (bw - 1), rect.width - bw, rect.height - 2, arcWidth, arcHeight);
        } else if (this.squareCornesWithAnchor) {
            int[] polygon = this.createAnchorPolygon(rect);
            gc.drawPolygon(polygon);
        } else {
            gc.drawRectangle(rect.x, rect.y, rect.width - bw, rect.height - 1);
        }
        gc.setAlpha(255);
        if (this.isFocused && this.selectionBorder) {
            gc.setForeground(this.currentFontColor);
            gc.setLineStyle(2);
            gc.setLineWidth(1);
            gc.drawRectangle(rect.x + (bw + 1), rect.y + (bw + 1), rect.width - (bw + 5), rect.height - (bw + 5));
        }
        if (this.imageStyle == IMAGE_RIGHT) {
            this.drawText(gc, x, y);
            if (this.image != null) {
                x = rect.width - x - this.image.getBounds().width + this.imagePadding;
                this.drawImage(gc, x, y);
            }
        } else {
            x = this.drawImage(gc, x, y);
            this.drawText(gc, x, y);
        }
        gc.dispose();
    }

    private int[] createAnchorPolygon(Rectangle rect) {
        int height = rect.height - 1;
        int middleHeight = height / 2;
        int width = rect.width - this.borderWidth - this.anchorWidth;
        int[] nArray = new int[14];
        nArray[2] = width;
        nArray[4] = width;
        nArray[5] = middleHeight - 4;
        nArray[6] = width + this.anchorWidth;
        nArray[7] = middleHeight;
        nArray[8] = width;
        nArray[9] = middleHeight + 4;
        nArray[10] = width;
        nArray[11] = height;
        nArray[13] = height;
        int[] polygon = nArray;
        return polygon;
    }

    private void drawText(GC gc, int x, int y) {
        if (this.text != null) {
            gc.setFont(this.font);
            gc.setForeground(this.currentFontColor);
            if (this.isTextOnCenter()) {
                x = (this.getSize().x - gc.textExtent((String)this.text).x) / 2;
            }
            gc.drawText(this.text, x, y, 1);
        }
    }

    private boolean isTextOnCenter() {
        return this.textOnCenter;
    }

    public void setTextOnCenter(boolean value) {
        this.textOnCenter = value;
    }

    private int drawImage(GC gc, int x, int y) {
        if (this.image == null) {
            return x;
        }
        x = x + this.imagePadding / 2 - (this.squareCornesWithAnchor ? this.anchorWidth / 2 : 0);
        gc.drawImage(this.image, x, y);
        return x + this.image.getBounds().width;
    }

    private void drawBackgroundImage(GC gc, Rectangle rect) {
        if (this.backgroundImage == null) {
            return;
        }
        Rectangle imgBounds = this.backgroundImage.getBounds();
        if (this.backgroundImageStyle == BG_IMAGE_STRETCH) {
            gc.drawImage(this.backgroundImage, 0, 0, imgBounds.width, imgBounds.height, rect.x, rect.y, rect.width, rect.height);
        } else if (this.backgroundImageStyle == BG_IMAGE_CENTER) {
            int x = (imgBounds.width - rect.width) / 2;
            int y = (imgBounds.height - rect.height) / 2;
            Rectangle centerRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
            if (x < 0) {
                centerRect.x -= x;
                x = 0;
            }
            if (y < 0) {
                centerRect.y -= y;
                y = 0;
            }
            this.drawClippedImage(gc, this.backgroundImage, x, y, centerRect);
        } else if (this.backgroundImageStyle == BG_IMAGE_TILE) {
            int y = 0;
            while (y < rect.height) {
                Rectangle tileRect = new Rectangle(rect.x, y + rect.y, rect.width, rect.height - y);
                int x = 0;
                while (x < rect.width) {
                    tileRect.x += this.drawClippedImage(gc, this.backgroundImage, 0, 0, tileRect);
                    tileRect.width -= x;
                    x += imgBounds.width;
                }
                y += imgBounds.height;
            }
        } else {
            this.drawClippedImage(gc, this.backgroundImage, 0, 0, rect);
        }
    }

    private int drawClippedImage(GC gc, Image image, int x, int y, Rectangle rect) {
        if (image != null) {
            Rectangle imgBounds = image.getBounds();
            int width = Math.min(imgBounds.width - x, rect.width);
            int height = Math.min(imgBounds.height - y, rect.height);
            gc.drawImage(image, x, y, width, height, rect.x, rect.y, width, height);
            return width;
        }
        return 0;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint == -1 && hHint == -1 && !changed && this.lastWidth > 0 && this.lastHeight > 0) {
            return new Point(this.lastWidth, this.lastHeight);
        }
        int width = 0;
        int height = 0;
        if (this.image != null) {
            Rectangle bounds = this.image.getBounds();
            width = bounds.width + this.imagePadding;
            height = bounds.height + this.innerMarginHeight * 2;
        }
        if (this.text != null) {
            GC gc = new GC((Drawable)this);
            gc.setFont(this.font);
            Point extent = gc.textExtent(this.text);
            gc.dispose();
            width += extent.x + this.innerMarginWidth * 2;
            height = Math.max(height, extent.y + this.innerMarginHeight * 2);
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        if (this.backgroundImage != null && this.backgroundImageStyle == BG_IMAGE_FIT) {
            width = this.backgroundImage.getBounds().width;
            height = this.backgroundImage.getBounds().height;
        }
        this.lastWidth = width + 2;
        this.lastHeight = height + 2;
        return new Point(this.lastWidth, this.lastHeight);
    }

    public void setImage(Image image) {
        this.image = image;
        this.redraw();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImageStyle(int imageStyle) {
        this.imageStyle = imageStyle;
    }

    public int getImageStyle() {
        return this.imageStyle;
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.redraw();
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImageStyle(int backgroundImageStyle) {
        this.backgroundImageStyle = backgroundImageStyle;
    }

    public int getBackgroundImageStyle() {
        return this.backgroundImageStyle;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    public void setEnabled(boolean enabled) {
        boolean oldSetting = this.enabled;
        this.enabled = enabled;
        if (oldSetting != enabled) {
            if (!enabled) {
                this.enabled = true;
                this.setInactiveColor(null);
                this.setTraversable(false);
                this.enabled = false;
            } else {
                this.setNormalColor(null);
                this.setTraversable(true);
            }
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setImagePadding(int imagePadding) {
        if (imagePadding >= 0) {
            this.imagePadding = imagePadding;
        }
    }

    public void setInnerMarginWidth(int innerMarginWidth) {
        if (innerMarginWidth >= 0) {
            this.innerMarginWidth = innerMarginWidth;
        }
    }

    public int getInnerMarginWidth() {
        return this.innerMarginWidth;
    }

    public void setInnerMarginHeight(int innerMarginHeight) {
        if (innerMarginHeight >= 0) {
            this.innerMarginHeight = innerMarginHeight;
        }
    }

    public int getInnerMarginHeight() {
        return this.innerMarginHeight;
    }

    public void setRoundedCorners(boolean roundedCorners) {
        this.roundedCorners = roundedCorners;
    }

    public boolean hasRoundedCorners() {
        return this.roundedCorners;
    }

    public void setSquareCornesWithAnchor(boolean squareCornesWithAnchor) {
        this.squareCornesWithAnchor = squareCornesWithAnchor;
    }

    public void setSelectionBorder(boolean selectionBorder) {
        this.selectionBorder = selectionBorder;
    }

    public boolean hasSelectionBorder() {
        return this.selectionBorder;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderAlpha(int borderAlpha) {
        this.borderAlpha = borderAlpha;
    }

    public int getBorderAlpha() {
        return this.borderAlpha;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setClickedBorderColor(Color clickedBorderColor) {
        this.clickedBorderColor = clickedBorderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setDefaultColors(Color bgColor1, Color bgColor2, Color bdrColor, Color fntColor) {
        if (bgColor1 != null) {
            this.backgroundColor = bgColor1;
        }
        if (bgColor2 != null) {
            this.backgroundColor2 = bgColor2;
        }
        if (bdrColor != null) {
            this.borderColor = bdrColor;
        }
        if (fntColor != null) {
            this.fontColor = fntColor;
        }
    }

    public void setHoverColors(Color bgColor1, Color bgColor2, Color bdrColor, Color fntColor) {
        if (bgColor1 != null) {
            this.hoverColor = bgColor1;
        }
        if (bgColor2 != null) {
            this.hoverColor2 = bgColor2;
        }
        if (bdrColor != null) {
            this.hoverBorderColor = bdrColor;
        }
        if (fntColor != null) {
            this.hoverFontColor = fntColor;
        }
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        this.hoverFontColor = fontColor;
        this.clickedFontColor = fontColor;
        this.selectedFontColor = fontColor;
        this.inactiveFontColor = fontColor;
    }

    public void setSelectedFontColor(Color selectedFontColor) {
        this.selectedFontColor = selectedFontColor;
    }

    public void setClickedColors(Color bgColor1, Color bgColor2, Color bdrColor, Color fntColor) {
        if (bgColor1 != null) {
            this.clickedColor = bgColor1;
        }
        if (bgColor2 != null) {
            this.clickedColor2 = bgColor2;
        }
        if (bdrColor != null) {
            this.clickedBorderColor = bdrColor;
        }
        if (fntColor != null) {
            this.clickedFontColor = fntColor;
        }
    }

    public void setSelectedColors(Color bgColor1, Color bgColor2, Color bdrColor, Color fntColor) {
        if (bgColor1 != null) {
            this.selectedColor = bgColor1;
        }
        if (bgColor2 != null) {
            this.selectedColor2 = bgColor2;
        }
        if (bdrColor != null) {
            this.selectedBorderColor = bdrColor;
        }
        if (fntColor != null) {
            this.selectedFontColor = fntColor;
        }
    }

    public void setInactiveColors(Color bgColor1, Color bgColor2, Color bdrColor, Color fntColor) {
        if (bgColor1 != null) {
            this.inactiveColor = bgColor1;
        }
        if (bgColor2 != null) {
            this.inactiveColor2 = bgColor2;
        }
        if (bdrColor != null) {
            this.inactiveBorderColor = bdrColor;
        }
        if (fntColor != null) {
            this.inactiveFontColor = fntColor;
        }
    }

    private static class ListenerAndEventType {
        private int eventType;
        private Listener listener;

        private ListenerAndEventType(int eventType, Listener listener) {
            this.setEventType(eventType);
            this.setListener(listener);
        }

        public int getEventType() {
            return this.eventType;
        }

        private void setEventType(int eventType) {
            this.eventType = eventType;
        }

        public Listener getListener() {
            return this.listener;
        }

        private void setListener(Listener listener) {
            this.listener = listener;
        }
    }
}

