/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class SelectionListDialog
extends SelectionStatusDialog {
    private ListViewer possibilities;
    private IBaseLabelProvider labelProvider;
    private String tooltip;
    private List<?> content;

    public SelectionListDialog(Shell parent, IBaseLabelProvider labelProvider) {
        super(parent);
        if (labelProvider == null) {
            throw new IllegalArgumentException("SelectionListDialog#labelProvider cannot be null");
        }
        this.labelProvider = labelProvider;
        this.content = new ArrayList();
        this.tooltip = null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.possibilities = this.createListArea(contents);
        return parent;
    }

    private ListViewer createListArea(Composite contents) {
        ListViewer possibilities = new ListViewer(contents, 2564);
        GridData data = new GridData();
        data.heightHint = this.convertHeightInCharsToPixels(this.content.size() + 5);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        possibilities.getControl().setLayoutData((Object)data);
        if (this.tooltip != null) {
            possibilities.getControl().setToolTipText(this.tooltip);
        }
        possibilities.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (!(inputElement instanceof List)) {
                    throw new IllegalArgumentException("SelectionDialog should receive List as content");
                }
                List elements = (List)inputElement;
                return elements.toArray(new Object[elements.size()]);
            }

            public void dispose() {
            }
        });
        possibilities.setLabelProvider(this.labelProvider);
        possibilities.setInput(this.content);
        return possibilities;
    }

    protected void computeResult() {
        IStructuredSelection selection = (IStructuredSelection)this.possibilities.getSelection();
        if (!selection.isEmpty()) {
            Object selectedElement = selection.getFirstElement();
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(selectedElement);
            this.setResult(result);
        }
    }

    public void setElements(List<?> content) {
        if (content == null) {
            throw new IllegalArgumentException("SelectionListDialog#content cannot be null");
        }
        this.content = content;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }
}

