/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.widgets.IMessageLogger;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.errors.ErrorItem;
import org.mule.tooling.ui.widgets.errors.ErrorListDialog;
import org.mule.tooling.ui.widgets.errors.ErrorType;
import org.mule.tooling.ui.widgets.errors.IErrorListProvider;
import org.mule.tooling.ui.widgets.menu.IContextMenuProvider;

public class MessageLogger
extends Composite
implements IMessageLogger,
IErrorListProvider {
    private static final String ERROR_LIST_MESSAGE = "Select the error to view the details or double click to navigate.";
    private CLabel label;
    private List<IMessageLogger.ValidationMessage> messages = new ArrayList<IMessageLogger.ValidationMessage>();
    private ErrorListDialog errorListDialog;
    private IMessageLogger.GoToIssueHandler handler;

    public MessageLogger(Composite parent, int style) {
        super(parent, style);
        this.setVisible(true);
        GridLayoutFactory.fillDefaults().margins(4, 0).applyTo((Composite)this);
        this.label = new CLabel((Composite)this, 16384);
        this.label.setBackground(Display.getCurrent().getSystemColor(1));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.label);
        this.errorListDialog = new ErrorListDialog(this.getShell(), this, new IContextMenuProvider<ErrorItem>(){

            @Override
            public void addActions(IMenuManager manager, Optional<ErrorItem> maybeSelectedElement) {
                if (maybeSelectedElement.isPresent()) {
                    manager.add((IAction)new GoToAction(maybeSelectedElement.get()));
                }
            }
        });
        this.errorListDialog.setDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ErrorItem firstElement = (ErrorItem)selection.getFirstElement();
                    new GoToAction(firstElement).run();
                }
            }
        });
        this.errorListDialog.setInitialMessage(ERROR_LIST_MESSAGE);
        this.errorListDialog.setSecondColumnName("Location");
        this.errorListDialog.setFirstColumnName("Message");
        this.errorListDialog.setErrorPresenter(new ErrorListDialog.IErrorItemPresenter(){

            @Override
            public String getSecondColumnValue(ErrorItem errorItem) {
                return errorItem.getLocation();
            }

            @Override
            public String getFirstColumnValue(ErrorItem errorItem) {
                return errorItem.getMessage();
            }
        });
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (!MessageLogger.this.messages.isEmpty()) {
                    MessageLogger.this.errorListDialog.open();
                    MessageLogger.this.errorListDialog.setMessage(MessageLogger.ERROR_LIST_MESSAGE);
                }
            }
        });
        this.refreshUI();
    }

    @Override
    public void addMessage(IMessageLogger.ValidationMessage message) {
        this.messages.add(message);
        this.refreshUI();
    }

    private void refreshUI() {
        boolean warnings;
        boolean errors = this.showMessagesOfType(IMessageLogger.ValidationMessageSeverity.ERROR, WidgetsImages.getImage("icons/error.png"));
        if (!errors && !(warnings = this.showMessagesOfType(IMessageLogger.ValidationMessageSeverity.WARNING, WidgetsImages.getImage("icons/warning.png")))) {
            this.label.setImage(WidgetsImages.getImage("icons/success.png"));
            this.label.setText("There are no errors.");
            this.label.setToolTipText("");
        }
    }

    private boolean showMessagesOfType(IMessageLogger.ValidationMessageSeverity type, Image severityIcon) {
        boolean hasMessages = this.hasMessageOfType(type);
        if (hasMessages) {
            int maxChars = this.calculateMaxCharsForLabel();
            List collect = this.getMessageOfType(type).collect(Collectors.toList());
            this.label.setImage(severityIcon);
            if (collect.size() == 1) {
                String theMessage = ((IMessageLogger.ValidationMessage)collect.get(0)).getMessage();
                this.label.setText(this.wrap(theMessage, maxChars));
            } else {
                this.label.setText(collect.size() + " issues found ...");
            }
            this.label.setToolTipText("Click to open the error details.");
            return true;
        }
        return false;
    }

    private boolean hasMessageOfType(IMessageLogger.ValidationMessageSeverity severity) {
        return this.getMessageOfType(severity).findFirst().isPresent();
    }

    private Stream<IMessageLogger.ValidationMessage> getMessageOfType(IMessageLogger.ValidationMessageSeverity severity) {
        return this.messages.stream().filter(message -> message.getSeverity() == severity);
    }

    @Override
    public void removeMessage(IMessageLogger.ValidationMessage message) {
        this.messages.remove(message);
        this.refreshUI();
    }

    private String wrap(String message, int maxChars) {
        if (((String)message).contains("\n")) {
            message = ((String)message).replaceAll("\n", " ");
        }
        if (!((String)message).trim().isEmpty() && ((String)message).length() > maxChars) {
            message = ((String)message).substring(0, maxChars - 3) + "...";
        }
        return message;
    }

    private int calculateMaxCharsForLabel() {
        int maxChars;
        int labelWidth = this.label.getSize().x;
        int defaultSize = 80;
        int n = maxChars = labelWidth > 0 ? labelWidth / this.getCharWidth((Control)this.label) : defaultSize;
        if (maxChars == 0) {
            maxChars = defaultSize;
        }
        return maxChars;
    }

    private int getCharWidth(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)1);
    }

    public String getText() {
        return this.label.getText();
    }

    @Override
    public void setMessages(List<IMessageLogger.ValidationMessage> errors) {
        this.messages.clear();
        this.messages.addAll(errors);
        this.refreshUI();
    }

    @Override
    public List<ErrorItem> getIssues() {
        return this.messages.stream().filter(message -> message.getSeverity() == IMessageLogger.ValidationMessageSeverity.ERROR || message.getSeverity() == IMessageLogger.ValidationMessageSeverity.WARNING).map(message -> {
            ErrorItem.ErrorItemBuilder errorItemBuilder = new ErrorItem.ErrorItemBuilder();
            errorItemBuilder.withMessage(message.getMessage());
            IMessageLogger.ValidationMessageSeverity severity = message.getSeverity();
            if (severity == IMessageLogger.ValidationMessageSeverity.ERROR) {
                errorItemBuilder.withErrorType(ErrorType.ERROR);
            } else {
                errorItemBuilder.withErrorType(ErrorType.WARNING);
            }
            errorItemBuilder.withLocation(message.getLocation());
            errorItemBuilder.withTitle(message.getLocation());
            errorItemBuilder.withDescription(message.getMessage());
            return errorItemBuilder.build();
        }).collect(Collectors.toList());
    }

    @Override
    public void setGoToHandler(IMessageLogger.GoToIssueHandler handler) {
        this.handler = handler;
    }

    private final class GoToAction
    extends Action {
        private ErrorItem errorItem;

        public GoToAction(ErrorItem componentPath) {
            super("Go to", 0);
            this.errorItem = componentPath;
            this.setImageDescriptor(WidgetsImages.getImageDescriptor("icons/goto.gif"));
        }

        public void run() {
            MessageLogger.this.handler.goTo(this.errorItem.getLocation());
        }
    }
}

