/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.browser.BrowserProxy;
import org.mule.tooling.browser.IBrowser;
import org.mule.tooling.ui.widgets.WidgetsActivator;

public class LocalResourceBrowser
extends Composite {
    private String fileUrl;
    protected Point browserSize;
    private IBrowser browser;
    protected boolean openInExternalBrowser = false;

    public LocalResourceBrowser(Composite parentComposite, Point size, String url) {
        super(parentComposite, 0);
        this.browserSize = size;
        this.fileUrl = url;
        this.browser = BrowserProxy.createBrowser((Composite)this);
        this.browser.setUrl(this.getUrl());
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        GridDataFactory.fillDefaults().hint(this.browserSize).grab(true, true).applyTo((Control)this.browser.getComposite());
        this.addWindowsListeners();
    }

    private void addWindowsListeners() {
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                if (LocalResourceBrowser.this.openInExternalBrowser) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(event.location));
                    }
                    catch (PartInitException e) {
                        WidgetsActivator.logError("Error when trying to open an external browser", e);
                    }
                    catch (MalformedURLException e) {
                        WidgetsActivator.logError(MessageFormat.format("Error when trying to create a new URL from location ''{0}''", event.location), e);
                    }
                    event.doit = false;
                    LocalResourceBrowser.this.openInExternalBrowser = false;
                }
            }
        });
        this.browser.addOpenWindowListener(() -> {});
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.browser.addProgressListener(progressListener);
    }

    public boolean execute(String script) {
        return this.browser.execute(script);
    }

    public Object evaluate(String script) {
        return this.browser.evaluate(script);
    }

    public String getUrl() {
        return this.fileUrl;
    }

    public Composite getBrowserComposite() {
        return this.browser.getComposite();
    }

    public IBrowser getBrowser() {
        return this.browser;
    }
}

