/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.mule.tooling.ui.widgets.SquareButton;

public class FlatCheckbox
extends SquareButton {
    private boolean checked = false;
    private int width;
    private Color tickColor = this.getDisplay().getSystemColor(1);

    public FlatCheckbox(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void paintControl(PaintEvent e) {
        if (this.currentColor == null) {
            this.currentColor = this.backgroundColor;
            this.currentColor2 = this.backgroundColor2;
            this.currentBorderColor = this.borderColor;
            this.currentFontColor = this.fontColor;
        }
        Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getWidth());
        GC gc = e.gc;
        gc.setAntialias(1);
        gc.setAdvanced(true);
        gc.setBackground(this.currentColor);
        gc.setForeground(this.currentColor);
        gc.fillRectangle(rect.x, rect.y, this.getWidth(), this.getWidth());
        gc.drawRectangle(rect.x, rect.y, this.getWidth(), this.getWidth());
        if (this.checked) {
            gc.setForeground(this.getTickColor());
            gc.setLineWidth(2);
            gc.drawLine(rect.x + rect.width / 5 - rect.width / 10, rect.height / 2, rect.width / 2, rect.height - rect.width / 6);
            gc.drawLine(rect.width / 2, rect.height - rect.width / 6, rect.width - rect.width / 5, rect.width / 2 - rect.width / 3 + rect.width / 8);
        }
        gc.dispose();
    }

    @Override
    protected void doButtonClicked() {
        super.doButtonClicked();
        this.checked = !this.checked;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.width, this.width);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.width, this.width);
    }

    public Point getSize() {
        return new Point(this.width, this.width);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setSelection(boolean b) {
        this.checked = b;
    }

    public boolean getSelection() {
        return this.checked;
    }

    public void setTickColor(Color tickColor) {
        this.tickColor = tickColor;
    }

    public Color getTickColor() {
        return this.tickColor;
    }
}

