/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.widgets.chips.Chips;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.theme.IStudioTheme;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class ChipsContainer
extends Composite {
    private static final String ADD_NEW_CHIP_TOOLTIP = "Add a new %s";
    private static final String NOT_ALLOWED_VALUE_ERROR_SUFIX = " is not an allowed value";
    private static final String REMOVE_ALL_CHIPS_TITLE = "Remove every %s";
    private static final String REMOVE_ALL_CHIPS_QUESTION = "Are you sure you want to remove every %s?";
    private List<IChipsContainerStateEventListener> listeners = new ArrayList<IChipsContainerStateEventListener>();
    private List<Chips> chips = new ArrayList<Chips>();
    private final List<String> allowedValues;
    private final Image addButtonImage;
    private final Image removeAllButtonImage;
    private final Image duplicatedChipErrorImage;
    private Color textColor;
    private Color backgroundColor;
    private Color closeXColor;
    private Color closeBackgroundColor;
    private Color hoverTextColor;
    private Color hoverBackgroundColor;
    private Color hoverCloseXColor;
    private Color hoverCloseBackgroundColor;
    private String chipsTypeName;
    private Integer maxVisibleTextLength;
    private final boolean showRemoveAllButton;
    private boolean allowRepeatedElements = true;
    private final boolean useFixedValues;
    private Integer keyCodeForCreation;
    private Pattern inputRegex;
    private Pattern validationRegex;
    private Composite inputComposite;
    private Text textInput;
    private ComboViewer fixedOptionsCombo;
    private ToolItem addButton;
    private ToolItem removeButton;

    public ChipsContainer(Composite parent, String chipsTypeName, boolean showRemoveAllButton, Image addButtonImage, Image removeAllButtonImage, Image duplicatedChipErrorImage, List<String> allowedValues, Pattern inputRegex, Pattern validationRegex) {
        super(parent, 0);
        this.chipsTypeName = chipsTypeName != null && !chipsTypeName.isBlank() ? chipsTypeName : "element";
        this.showRemoveAllButton = showRemoveAllButton;
        this.addButtonImage = addButtonImage;
        this.removeAllButtonImage = removeAllButtonImage;
        this.duplicatedChipErrorImage = duplicatedChipErrorImage;
        this.allowedValues = allowedValues;
        this.useFixedValues = allowedValues != null;
        this.inputRegex = inputRegex;
        this.validationRegex = validationRegex;
        this.setupChipsColors();
        this.createControls();
    }

    public ChipsContainer(Composite parent, String chipsTypeName, boolean showRemoveAllButton) {
        this(parent, chipsTypeName, showRemoveAllButton, Pattern.compile(".*"), Pattern.compile(".+"));
    }

    public ChipsContainer(Composite parent, String chipsTypeName, boolean showRemoveAllButton, Pattern inputRegex, Pattern validationRegex) {
        this(parent, chipsTypeName, showRemoveAllButton, null, null, null, null, inputRegex, validationRegex);
    }

    public ChipsContainer(Composite parent, List<String> allowedValues) {
        this(parent, null, false, null, null, null, allowedValues, Pattern.compile(".*"), Pattern.compile(".+"));
        Assert.isNotNull(allowedValues, (String)"The allowedValues parameter couldn't be null");
    }

    public void setMaxVisibleTextLength(Integer maxLength) {
        this.maxVisibleTextLength = maxLength;
    }

    public void allowRepeatedElements(boolean allowRepeatedElements) {
        this.allowRepeatedElements = allowRepeatedElements;
    }

    public void setKeyCodeForCreation(Integer keyCodeForCreation) {
        this.keyCodeForCreation = keyCodeForCreation;
    }

    private void setupChipsColors() {
        IStudioTheme currentTheme = ThemeUtils.getCurrentTheme();
        this.textColor = currentTheme.getChipsTextColor();
        this.backgroundColor = currentTheme.getChipsBackgroundColor();
        this.closeXColor = currentTheme.getChipsCloseXColor();
        this.closeBackgroundColor = currentTheme.getChipsCloseBackgroundColor();
        this.hoverTextColor = currentTheme.getChipsHoverTextColor();
        this.hoverBackgroundColor = currentTheme.getChipsHoverBackgroundColor();
        this.hoverCloseXColor = currentTheme.getChipsHoverCloseXColor();
        this.hoverCloseBackgroundColor = currentTheme.getChipsHoverCloseBackgroundColor();
    }

    private void createControls() {
        RowLayoutFactory.fillDefaults().type(256).applyTo((Composite)this);
        this.inputComposite = new Composite((Composite)this, 0);
        if (this.useFixedValues) {
            GridLayoutFactory.fillDefaults().applyTo(this.inputComposite);
            this.createComboSection();
        } else {
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.inputComposite);
            this.createTextSection();
            this.createToolbarSection();
        }
    }

    private void createComboSection() {
        this.fixedOptionsCombo = new ComboViewer(this.inputComposite, 12);
        this.fixedOptionsCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fixedOptionsCombo.setComparator(new ViewerComparator());
        this.fixedOptionsCombo.setInput(this.allowedValues);
        this.fixedOptionsCombo.addSelectionChangedListener(event -> {
            if (this.fixedOptionsCombo.getStructuredSelection().getFirstElement() != null) {
                this.createNewChip(this.fixedOptionsCombo.getStructuredSelection().getFirstElement().toString());
                this.fixedOptionsCombo.getControl().setFocus();
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).hint(80, 20).applyTo(this.fixedOptionsCombo.getControl());
    }

    private void createTextSection() {
        this.textInput = new Text(this.inputComposite, 2048);
        GridDataFactory.fillDefaults().grab(false, false).hint(80, this.textInput.getSize().y).applyTo((Control)this.textInput);
        this.textInput.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String oldText = ChipsContainer.this.textInput.getText();
                String newText = oldText.substring(0, e.start) + e.text + oldText.substring(e.end);
                if (!newText.isEmpty() && !ChipsContainer.this.inputRegex.matcher(newText).matches()) {
                    e.doit = false;
                }
            }
        });
        this.textInput.addModifyListener(e -> {
            if (!this.allowRepeatedElements) {
                if (this.chips.stream().map(Control::getToolTipText).anyMatch(this.textInput.getText().trim()::equals)) {
                    this.addButton.setEnabled(false);
                    this.addButton.setToolTipText("Repeated values are not allowed");
                    return;
                }
            }
            if (!this.textInput.getText().isEmpty() && !this.validationRegex.matcher(this.textInput.getText()).matches()) {
                this.addButton.setEnabled(false);
                this.addButton.setToolTipText("Value is invalid");
                return;
            }
            this.addButton.setEnabled(true);
            this.addButton.setToolTipText(String.format(ADD_NEW_CHIP_TOOLTIP, this.chipsTypeName));
        });
        this.textInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (ChipsContainer.this.keyCodeForCreation != null && e.keyCode == ChipsContainer.this.keyCodeForCreation && ChipsContainer.this.addButton.isEnabled()) {
                    ChipsContainer.this.createNewChip(ChipsContainer.this.textInput.getText());
                    ChipsContainer.this.textInput.setFocus();
                }
            }
        });
    }

    private void createToolbarSection() {
        ToolBar toolBar = new ToolBar(this.inputComposite, 0x800000);
        this.addButton = new ToolItem(toolBar, 8);
        this.addButton.setToolTipText(String.format(ADD_NEW_CHIP_TOOLTIP, this.chipsTypeName));
        if (this.addButtonImage != null) {
            this.addButton.setImage(this.addButtonImage);
        } else {
            this.addButton.setImage(WidgetsImages.getImage("icons/add.png"));
        }
        if (this.duplicatedChipErrorImage != null) {
            this.addButton.setDisabledImage(this.duplicatedChipErrorImage);
        } else {
            this.addButton.setDisabledImage(WidgetsImages.getImage("icons/requirements/error.png"));
        }
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChipsContainer.this.createNewChip(ChipsContainer.this.textInput.getText());
                ChipsContainer.this.textInput.setFocus();
            }
        });
        if (this.showRemoveAllButton) {
            this.removeButton = new ToolItem(toolBar, 8);
            this.removeButton.setToolTipText(String.format(REMOVE_ALL_CHIPS_TITLE, this.chipsTypeName));
            if (this.removeAllButtonImage != null) {
                this.removeButton.setImage(this.removeAllButtonImage);
            } else {
                this.removeButton.setImage(WidgetsImages.getImage("icons/remove-all.png"));
            }
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MessageDialog.openQuestion((Shell)ChipsContainer.this.getParent().getShell(), (String)String.format(ChipsContainer.REMOVE_ALL_CHIPS_TITLE, ChipsContainer.this.chipsTypeName), (String)String.format(ChipsContainer.REMOVE_ALL_CHIPS_QUESTION, ChipsContainer.this.chipsTypeName))) {
                        for (Chips chip : ChipsContainer.this.chips) {
                            chip.dispose();
                        }
                        ChipsContainer.this.chips.clear();
                        ChipsContainer.this.textInput.setText("");
                        ChipsContainer.this.removeButton.setEnabled(false);
                        ChipsContainer.this.requestLayout();
                        ChipsContainer.this.notifyListeners();
                    }
                }
            });
            this.removeButton.setEnabled(false);
        }
        GridDataFactory.fillDefaults().grab(false, false).indent(-5, 0).applyTo((Control)toolBar);
    }

    public void createNewChip(String chipText) {
        if (chipText.isBlank() || !this.allowRepeatedElements && this.getChipsContents().contains(chipText)) {
            return;
        }
        Chips newChip = new Chips((Composite)this, 64);
        this.setTextAndTooltip(newChip, chipText.trim());
        this.changeChipColors(newChip);
        newChip.addCloseListener(event -> {
            if (this.useFixedValues && this.isValid(newChip)) {
                this.fixedOptionsCombo.add((Object)newChip.getToolTipText());
                this.fixedOptionsCombo.getControl().setEnabled(true);
            }
            this.chips.remove(newChip);
            newChip.dispose();
            if (this.chips.isEmpty() && this.showRemoveAllButton) {
                this.removeButton.setEnabled(false);
            }
            this.requestLayout();
            this.notifyListeners();
        });
        this.chips.add(newChip);
        if (this.useFixedValues) {
            this.fixedOptionsCombo.setSelection(null);
            if (!this.allowRepeatedElements) {
                this.fixedOptionsCombo.remove((Object)chipText);
                if (this.fixedOptionsCombo.getElementAt(0) == null) {
                    this.fixedOptionsCombo.getControl().setEnabled(false);
                }
            }
        } else {
            this.textInput.setText("");
        }
        if (!this.isValid(newChip)) {
            newChip.setImage(WidgetsImages.getImage("icons/requirements/error.png"));
            newChip.setToolTipText(chipText + NOT_ALLOWED_VALUE_ERROR_SUFIX);
        }
        this.inputComposite.moveBelow((Control)newChip);
        if (this.showRemoveAllButton) {
            this.removeButton.setEnabled(true);
        }
        this.requestLayout();
        this.notifyListeners();
    }

    private void setTextAndTooltip(Chips newChip, String chipText) {
        Object textToDisplay = chipText;
        if (this.maxVisibleTextLength != null && ((String)textToDisplay).length() > this.maxVisibleTextLength) {
            textToDisplay = ((String)textToDisplay).substring(0, this.maxVisibleTextLength) + "...";
        }
        newChip.setText((String)textToDisplay);
        newChip.setToolTipText(chipText);
    }

    private void changeChipColors(Chips newChip) {
        if (this.textColor != null) {
            newChip.setForeground(this.textColor);
        }
        if (this.backgroundColor != null) {
            newChip.setChipsBackground(this.backgroundColor);
        }
        if (this.closeXColor != null) {
            newChip.setCloseButtonForeground(this.closeXColor);
        }
        if (this.closeBackgroundColor != null) {
            newChip.setCloseButtonBackground(this.closeBackgroundColor);
        }
        if (this.hoverTextColor != null) {
            newChip.setHoverForeground(this.hoverTextColor);
        }
        if (this.hoverBackgroundColor != null) {
            newChip.setHoverBackground(this.hoverBackgroundColor);
        }
        if (this.hoverCloseXColor != null) {
            newChip.setCloseButtonHoverForeground(this.hoverCloseXColor);
        }
        if (this.hoverCloseBackgroundColor != null) {
            newChip.setCloseButtonHoverBackground(this.hoverCloseBackgroundColor);
        }
    }

    public List<String> getChipsContents() {
        ArrayList<String> result = new ArrayList<String>();
        for (Chips chip : this.chips) {
            if (this.isValid(chip)) {
                result.add(chip.getToolTipText());
                continue;
            }
            result.add(chip.getToolTipText().substring(0, chip.getToolTipText().lastIndexOf(NOT_ALLOWED_VALUE_ERROR_SUFIX)));
        }
        return result;
    }

    private boolean isValid(Chips chip) {
        if (this.useFixedValues) {
            return this.allowedValues.contains(chip.getToolTipText());
        }
        return this.validationRegex.matcher(chip.getToolTipText()).matches();
    }

    public void clearChips() {
        this.chips.forEach(Widget::dispose);
        this.chips.clear();
    }

    public void addChipsContainerStateEventListener(IChipsContainerStateEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeChipsContainerStateEventListener(IChipsContainerStateEventListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        this.listeners.forEach(IChipsContainerStateEventListener::update);
    }

    public static interface IChipsContainerStateEventListener {
        public void update();
    }
}

