/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.application.properties.handlers;

import com.mulesoft.agent.services.application.properties.configuration.protocols.FileProtocolConfiguration;
import com.mulesoft.agent.services.application.properties.handlers.ProtocolHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileProtocolHandler
implements ProtocolHandler {
    public static final String FILE_PROTOCOL = "file://";
    private static final Logger LOGGER = LogManager.getLogger(FileProtocolHandler.class);
    private final FileProtocolConfiguration oldConfiguration;
    private final FileProtocolConfiguration newConfiguration;

    public FileProtocolHandler(FileProtocolConfiguration oldConfiguration, FileProtocolConfiguration newConfiguration) {
        this.oldConfiguration = oldConfiguration;
        this.newConfiguration = newConfiguration;
        if (oldConfiguration != null) {
            LOGGER.warn("fileProtocolConfiguration would be deprecated in the next version please migrate to supportedProtocols configuration");
        }
    }

    @Override
    public String resolve(String value) throws IOException, URISyntaxException {
        URI uri = new URI(value);
        try (InputStream inputStream = uri.toURL().openStream();){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @Override
    public boolean supports(String value) {
        boolean enabled = this.isEnabled(this.oldConfiguration) || this.isEnabled(this.newConfiguration);
        String[] oldWhitelistedDirectories = this.getWhitelistedDirectories(this.oldConfiguration);
        String[] newWhitelistedDirectories = this.getWhitelistedDirectories(this.newConfiguration);
        String[] whitelistedDirectories = null;
        if (oldWhitelistedDirectories != null || newWhitelistedDirectories != null) {
            int oldLength = oldWhitelistedDirectories != null ? oldWhitelistedDirectories.length : 0;
            int newLength = newWhitelistedDirectories != null ? newWhitelistedDirectories.length : 0;
            whitelistedDirectories = new String[oldLength + newLength];
            if (oldWhitelistedDirectories != null && oldLength > 0) {
                System.arraycopy(oldWhitelistedDirectories, 0, whitelistedDirectories, 0, oldLength);
            }
            if (newWhitelistedDirectories != null && newLength > 0) {
                System.arraycopy(newWhitelistedDirectories, 0, whitelistedDirectories, oldLength, newLength);
            }
        }
        if (!enabled || enabled && !value.startsWith(FILE_PROTOCOL)) {
            return false;
        }
        Path filePath = Paths.get(value.replaceFirst(FILE_PROTOCOL, ""), new String[0]).normalize();
        return whitelistedDirectories == null || whitelistedDirectories.length == 0 || Arrays.stream(whitelistedDirectories).anyMatch(directory -> filePath.getParent().compareTo(Paths.get(directory, new String[0]).toAbsolutePath()) == 0);
    }

    private boolean isEnabled(FileProtocolConfiguration configuration) {
        return configuration != null && configuration.isEnabled();
    }

    private String[] getWhitelistedDirectories(FileProtocolConfiguration configuration) {
        return configuration != null ? configuration.getWhitelistedDirectories() : null;
    }
}

