/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.application.properties.handlers;

import com.mulesoft.agent.services.application.properties.configuration.protocols.EnvironmentProtocolConfiguration;
import com.mulesoft.agent.services.application.properties.handlers.ProtocolHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnvironmentProtocolHandler
implements ProtocolHandler {
    public static final String DEFAULT_PREFIX = "${";
    public static final String DEFAULT_SUFFIX = "}";
    private static final Logger LOGGER = LogManager.getLogger(EnvironmentProtocolHandler.class);
    private final EnvironmentProtocolConfiguration configuration;
    private final EnvironmentVariableResolver environmentVariableResolver;

    public EnvironmentProtocolHandler(EnvironmentProtocolConfiguration configuration, EnvironmentVariableResolver environmentVariableResolver) {
        this.configuration = configuration;
        this.environmentVariableResolver = environmentVariableResolver;
    }

    @Override
    public String resolve(String value) {
        String variableName = value.substring(value.indexOf(DEFAULT_PREFIX) + DEFAULT_PREFIX.length(), value.lastIndexOf(DEFAULT_SUFFIX));
        LOGGER.info("Looking value for environment variable {}", (Object)variableName);
        return this.environmentVariableResolver.resolve(variableName);
    }

    @Override
    public boolean supports(String value) {
        boolean enabled = this.isEnabled(this.configuration);
        return enabled && value.startsWith(DEFAULT_PREFIX) && value.endsWith(DEFAULT_SUFFIX);
    }

    private boolean isEnabled(EnvironmentProtocolConfiguration configuration) {
        return configuration != null && configuration.isEnabled();
    }

    public static interface EnvironmentVariableResolver {
        public String resolve(String var1);
    }
}

