/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.application.properties.handlers;

import com.mulesoft.agent.services.application.properties.configuration.protocols.DirectoryProtocolConfiguration;
import com.mulesoft.agent.services.application.properties.handlers.ProtocolHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryProtocolHandler
implements ProtocolHandler {
    private static final String PROPERTIES_EXTENSION = ".properties";
    public static final String DEFAULT_BASE_DIRECTORY = "/etc/mule/properties";
    private static final Logger LOGGER = LogManager.getLogger(DirectoryProtocolHandler.class);
    private final DirectoryProtocolConfiguration configuration;

    public DirectoryProtocolHandler(DirectoryProtocolConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String resolve(String value) throws Exception {
        throw new UnsupportedOperationException("DirectoryProtocolHandler does not resolve individual property values. Use loadPropertiesFromDirectory() instead.");
    }

    @Override
    public boolean supports(String value) {
        return false;
    }

    public Properties loadPropertiesFromDirectory() {
        Properties properties = new Properties();
        if (!this.isEnabled()) {
            LOGGER.debug("Directory protocol is disabled");
            return properties;
        }
        String baseDirectory = this.getBaseDirectory();
        if (baseDirectory == null || baseDirectory.trim().isEmpty()) {
            LOGGER.warn("Directory protocol is enabled but no base directory is configured");
            return properties;
        }
        Path directoryPath = Paths.get(baseDirectory, new String[0]);
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            LOGGER.info("Directory {} does not exist, skipping directory property loading", (Object)baseDirectory);
            return properties;
        }
        if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
            LOGGER.warn("Path {} is not a directory, skipping directory property loading", (Object)baseDirectory);
            return properties;
        }
        try {
            LOGGER.info("Loading properties from directory: {}", (Object)baseDirectory);
            this.loadPropertiesRecursively(directoryPath, properties);
            LOGGER.info("Loaded {} properties from directory {}", (Object)properties.size(), (Object)baseDirectory);
        }
        catch (IOException e) {
            LOGGER.error("Error loading properties from directory {}: {}", (Object)baseDirectory, (Object)e.getMessage(), (Object)e);
        }
        return properties;
    }

    private void loadPropertiesRecursively(Path directory, Properties properties) throws IOException {
        try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]).sorted();){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadPropertiesFromFile((Path)file, properties));
        }
    }

    private void loadPropertiesFromFile(Path file, Properties properties) {
        try {
            String fileName = file.getFileName().toString();
            if (fileName.endsWith(PROPERTIES_EXTENSION)) {
                this.loadJavaPropertiesFile(file, properties);
            } else {
                this.loadIndividualPropertyFile(file, properties);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error loading properties from file {}: {}", (Object)file, (Object)e.getMessage(), (Object)e);
        }
    }

    private void loadJavaPropertiesFile(Path file, Properties properties) throws IOException {
        LOGGER.debug("Loading Java properties file: {}", (Object)file);
        Properties fileProperties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            fileProperties.load(reader);
            for (String key : fileProperties.stringPropertyNames()) {
                String value = fileProperties.getProperty(key);
                properties.setProperty(key, value);
                LOGGER.debug("Loaded property from {}: {}={}", (Object)file, (Object)key, (Object)value);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading properties file {}: {}", (Object)file, (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private void loadIndividualPropertyFile(Path file, Properties properties) throws IOException {
        String fileName = file.getFileName().toString();
        LOGGER.debug("Loading individual property file: {}", (Object)file);
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String content = IOUtils.toString((Reader)reader);
            content = content != null ? content.trim() : "";
            properties.setProperty(fileName, content);
            LOGGER.debug("Loaded property from {}: {}={}", (Object)file, (Object)fileName, (Object)content);
        }
        catch (IOException e) {
            LOGGER.error("Error reading individual property file {}: {}", (Object)file, (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private boolean isEnabled() {
        return this.configuration != null && this.configuration.isEnabled();
    }

    private String getBaseDirectory() {
        return this.configuration != null ? (StringUtils.isBlank((CharSequence)this.configuration.getBaseDirectory()) ? DEFAULT_BASE_DIRECTORY : this.configuration.getBaseDirectory()) : DEFAULT_BASE_DIRECTORY;
    }
}

