/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.application.properties;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.ConfigurationLevel;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.application.properties.ApplicationPropertiesConfiguration;
import com.mulesoft.agent.services.application.properties.configuration.SupportedProtocolsConfiguration;
import com.mulesoft.agent.services.application.properties.configuration.protocols.FileProtocolConfiguration;
import com.mulesoft.agent.services.application.properties.handlers.DirectoryProtocolHandler;
import com.mulesoft.agent.services.application.properties.handlers.EnvironmentProtocolHandler;
import com.mulesoft.agent.services.application.properties.handlers.FileProtocolHandler;
import com.mulesoft.agent.services.application.properties.handlers.ProtocolHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.application.properties.service")
@Singleton
public class AgentApplicationPropertiesService
extends ConfigurableAgentService {
    private static final Logger LOGGER = LogManager.getLogger(AgentApplicationPropertiesService.class);
    private static final ProtocolHandler PLAIN_VALUE_HANDLER = new PlainValueProtocolHandler();
    private final EnvironmentProtocolHandler.EnvironmentVariableResolver environmentVariableResolver;
    @Configurable(type=Type.DYNAMIC, value="[]", level=ConfigurationLevel.APPLICATION)
    private ApplicationPropertiesConfiguration[] applicationPropertiesConfigurations;
    @Configurable
    private FileProtocolConfiguration fileProtocolConfiguration;
    @Configurable(value="{}")
    private SupportedProtocolsConfiguration supportedProtocols;
    private List<ProtocolHandler> protocolHandlers = Collections.emptyList();
    private DirectoryProtocolHandler directoryProtocolHandler;

    public AgentApplicationPropertiesService() {
        this(System::getenv);
    }

    public AgentApplicationPropertiesService(EnvironmentProtocolHandler.EnvironmentVariableResolver environmentVariableResolver) {
        this.environmentVariableResolver = environmentVariableResolver;
    }

    public Properties getPropertiesForApplication(String applicationName) {
        Properties properties = new Properties();
        if (this.directoryProtocolHandler != null) {
            try {
                Properties directoryProperties = this.directoryProtocolHandler.loadPropertiesFromDirectory();
                if (directoryProperties != null && !directoryProperties.isEmpty()) {
                    properties.putAll((Map<?, ?>)directoryProperties);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error loading directory properties for application {}: {}", (Object)applicationName, (Object)e.getMessage(), (Object)e);
            }
        }
        for (ApplicationPropertiesConfiguration applicationPropertiesConfiguration : this.applicationPropertiesConfigurations) {
            if (!applicationPropertiesConfiguration.getApplicationName().equals(applicationName)) continue;
            for (Map.Entry<String, String> property : applicationPropertiesConfiguration.getProperties().entrySet()) {
                try {
                    this.processProperty(this.getProtocolHandler(property.getValue()), properties, property);
                }
                catch (Exception e) {
                    LOGGER.error("Could not load property {} from file for application: {}", (Object)property.getKey(), (Object)applicationName, (Object)e);
                }
            }
            return properties;
        }
        LOGGER.debug("No configuration found for application: {}", (Object)applicationName);
        return properties;
    }

    protected void doStart() {
        this.protocolHandlers = new ArrayList<ProtocolHandler>();
        this.protocolHandlers.add(new FileProtocolHandler(this.fileProtocolConfiguration, this.supportedProtocols != null ? this.supportedProtocols.getFile() : null));
        this.protocolHandlers.add(new EnvironmentProtocolHandler(this.supportedProtocols != null ? this.supportedProtocols.getEnv() : null, this.environmentVariableResolver));
        this.directoryProtocolHandler = new DirectoryProtocolHandler(this.supportedProtocols != null ? this.supportedProtocols.getDirectory() : null);
    }

    protected void doStop() {
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>();
    }

    private void processProperty(ProtocolHandler protocolHandler, Properties properties, Map.Entry<String, String> property) throws Exception {
        if (protocolHandler == null) {
            return;
        }
        String key = property.getKey();
        String value = property.getValue();
        try {
            properties.put(key, protocolHandler.resolve(value));
        }
        catch (NullPointerException ex) {
            if (protocolHandler instanceof EnvironmentProtocolHandler) {
                LOGGER.warn(String.format("Unable to find value of environment variable %s", value));
            }
            throw ex;
        }
    }

    private ProtocolHandler getProtocolHandler(String value) {
        for (ProtocolHandler handler : this.protocolHandlers) {
            if (!handler.supports(value)) continue;
            return handler;
        }
        return PLAIN_VALUE_HANDLER;
    }

    private static class PlainValueProtocolHandler
    implements ProtocolHandler {
        private PlainValueProtocolHandler() {
        }

        @Override
        public String resolve(String value) {
            return value;
        }

        @Override
        public boolean supports(String value) {
            return true;
        }
    }
}

