/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.utils.JdkVersion;

public class DataStructures {
    private static final Class<?> LTQclass;

    private static Class<?> getAndVerify(String cname) throws Throwable {
        return DataStructures.class.getClassLoader().loadClass(cname).newInstance().getClass();
    }

    public static <T> BlockingQueue<T> getLTQInstance() {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <T> BlockingQueue<T> getLTQInstance(Class<T> t) {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap(Map<? extends K, ? extends V> map) {
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    static {
        Class c;
        String className = null;
        try {
            JdkVersion jdkVersion = JdkVersion.getJdkVersion();
            JdkVersion jdk17Version = JdkVersion.parseVersion("1.7.0");
            className = jdk17Version.compareTo(jdkVersion) <= 0 ? "java.util.concurrent.LinkedTransferQueue" : "org.glassfish.grizzly.utils.LinkedTransferQueue";
            c = DataStructures.getAndVerify(className);
            Grizzly.logger(DataStructures.class).debug("USING LTQ class:{}", c);
        }
        catch (Throwable t) {
            Grizzly.logger(DataStructures.class).debug("failed loading datastructure class: {} fallback to embedded one", className, (Object)t);
            c = LinkedBlockingQueue.class;
        }
        LTQclass = c;
    }
}

