/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.attributes;

import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.DefaultAttributeBuilder;
import org.slf4j.Logger;

class AttributeBuilderInitializer {
    private static final String PROP = "org.glassfish.grizzly.DEFAULT_ATTRIBUTE_BUILDER";
    private static final Logger LOGGER = Grizzly.logger(AttributeBuilderInitializer.class);

    AttributeBuilderInitializer() {
    }

    static AttributeBuilder initBuilder() {
        String className = System.getProperty(PROP);
        if (className != null) {
            try {
                Class<?> builderClass = Class.forName(className, true, AttributeBuilder.class.getClassLoader());
                return (AttributeBuilder)builderClass.newInstance();
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Unable to load or create a new instance of AttributeBuilder {}.  Cause: {}", (Object)className, (Object)e.getMessage());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
                return new DefaultAttributeBuilder();
            }
        }
        return new DefaultAttributeBuilder();
    }
}

