/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.glassfish.grizzly.CloseType;

public class CloseReason {
    private static IOException LOCALLY_CLOSED = new IOException("Locally closed");
    private static IOException REMOTELY_CLOSED;
    public static final CloseReason LOCALLY_CLOSED_REASON;
    public static final CloseReason REMOTELY_CLOSED_REASON;
    private final CloseType type;
    private final IOException cause;

    public CloseReason(CloseType type, IOException cause) {
        this.type = type;
        this.cause = cause != null ? cause : (type == CloseType.LOCALLY ? LOCALLY_CLOSED : REMOTELY_CLOSED);
    }

    public CloseType getType() {
        return this.type;
    }

    public IOException getCause() {
        return this.cause;
    }

    static {
        LOCALLY_CLOSED.setStackTrace(new StackTraceElement[0]);
        REMOTELY_CLOSED = new IOException("Remotely closed");
        REMOTELY_CLOSED.setStackTrace(new StackTraceElement[0]);
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            new ObjectOutputStream(buffer).writeObject(LOCALLY_CLOSED);
            LOCALLY_CLOSED = (IOException)new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray())).readObject();
            new ObjectOutputStream(buffer).writeObject(REMOTELY_CLOSED);
            REMOTELY_CLOSED = (IOException)new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray())).readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception on cleaning CloseReason backtrace", e);
        }
        LOCALLY_CLOSED_REASON = new CloseReason(CloseType.LOCALLY, LOCALLY_CLOSED);
        REMOTELY_CLOSED_REASON = new CloseReason(CloseType.REMOTELY, REMOTELY_CLOSED);
    }
}

