/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;

public final class LogTimestampFormatter$ {
    public static LogTimestampFormatter$ MODULE$;
    private final ZoneId systemZone;
    private final DateTimeFormatter noSpaceTimestampFormat;
    private final DateTimeFormatter humanReadableTimestampFormatter;

    static {
        new LogTimestampFormatter$();
    }

    public ZoneId systemZone() {
        return this.systemZone;
    }

    public DateTimeFormatter noSpaceTimestampFormat() {
        return this.noSpaceTimestampFormat;
    }

    public DateTimeFormatter humanReadableTimestampFormatter() {
        return this.humanReadableTimestampFormatter;
    }

    public String formatTimestamp(long timeMillis) {
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeMillis), this.systemZone());
        return this.humanReadableTimestampFormatter().format(timestamp);
    }

    public String formatTimestampWithNoSpaace(long timeMillis) {
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeMillis), this.systemZone());
        return this.noSpaceTimestampFormat().format(timestamp);
    }

    private LogTimestampFormatter$() {
        MODULE$ = this;
        this.systemZone = ZoneId.systemDefault().normalized();
        this.noSpaceTimestampFormat = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3).appendOffset("+HHMM", "Z").toFormatter(Locale.US);
        this.humanReadableTimestampFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3).appendOffset("+HHMM", "Z").toFormatter(Locale.US);
    }
}

