/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.regex.Pattern;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.io.AnsiColor;
import scala.runtime.BoxesRunTime;
import wvlet.airframe.log.AnsiColorPalette;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$DEBUG$;
import wvlet.log.LogLevel$ERROR$;
import wvlet.log.LogLevel$INFO$;
import wvlet.log.LogLevel$TRACE$;
import wvlet.log.LogLevel$WARN$;
import wvlet.log.LogRecord;

public final class LogFormatter$
implements AnsiColorPalette {
    public static LogFormatter$ MODULE$;
    private final Pattern testFrameworkFilter;
    private final Function1<String, Object> DEFAULT_STACKTRACE_FILTER;
    private Function1<String, Object> stackTraceFilter;

    static {
        new LogFormatter$();
    }

    public String currentThreadName() {
        return Thread.currentThread().getName();
    }

    private Pattern testFrameworkFilter() {
        return this.testFrameworkFilter;
    }

    public Function1<String, Object> DEFAULT_STACKTRACE_FILTER() {
        return this.DEFAULT_STACKTRACE_FILTER;
    }

    private Function1<String, Object> stackTraceFilter() {
        return this.stackTraceFilter;
    }

    private void stackTraceFilter_$eq(Function1<String, Object> x$1) {
        this.stackTraceFilter = x$1;
    }

    public void setStackTraceFilter(Function1<String, Object> filter) {
        this.stackTraceFilter_$eq(filter);
    }

    public String formatStacktrace(Throwable e) {
        Throwable throwable = e;
        if (throwable == null) {
            return "";
        }
        StringWriter trace = new StringWriter();
        e.printStackTrace(new PrintWriter(trace));
        String[] stackTraceLines = trace.toString().split("\n");
        Iterator filtered = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stackTraceLines)).filter(this.stackTraceFilter()))).sliding(2).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String[], B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option option = Array$.MODULE$.unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    String a = (String)((SeqLike)option.get()).apply(0);
                    String b = (String)((SeqLike)option.get()).apply(1);
                    String string = a;
                    String string2 = b;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        return (B1)b;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String[] x1) {
                String[] stringArray = x1;
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    String a = (String)((SeqLike)option.get()).apply(0);
                    String b = (String)((SeqLike)option.get()).apply(1);
                    String string = a;
                    String string2 = b;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        return true;
                    }
                }
                return false;
            }
        });
        return ((TraversableOnce)Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stackTraceLines)).headOption()).$plus$plus((GenTraversableOnce)filtered, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String withColor(String prefix, String s) {
        return new StringBuilder(4).append(prefix).append(s).append("\u001b[0m").toString();
    }

    public String highlightLog(LogLevel level, String message) {
        LogLevel logLevel = level;
        String color = LogLevel$ERROR$.MODULE$.equals(logLevel) ? "\u001b[31m" : (LogLevel$WARN$.MODULE$.equals(logLevel) ? "\u001b[33m" : (LogLevel$INFO$.MODULE$.equals(logLevel) ? "\u001b[36m" : (LogLevel$DEBUG$.MODULE$.equals(logLevel) ? "\u001b[32m" : (LogLevel$TRACE$.MODULE$.equals(logLevel) ? "\u001b[35m" : "\u001b[0m"))));
        return this.withColor(color, message);
    }

    public String appendStackTrace(String m, LogRecord r, boolean coloring) {
        boolean bl = false;
        Some some = null;
        Option<Throwable> option = r.cause();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Throwable ex = (Throwable)some.value();
            if (coloring) {
                return new StringBuilder(1).append(m).append("\n").append(this.highlightLog(r.level(), this.formatStacktrace(ex))).toString();
            }
        }
        if (bl) {
            Throwable ex = (Throwable)some.value();
            return new StringBuilder(1).append(m).append("\n").append(this.formatStacktrace(ex)).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return m;
        }
        throw new MatchError(option);
    }

    public boolean appendStackTrace$default$3() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$DEFAULT_STACKTRACE_FILTER$1(String line) {
        return !MODULE$.testFrameworkFilter().matcher(line).matches();
    }

    private LogFormatter$() {
        MODULE$ = this;
        AnsiColor.$init$((AnsiColor)this);
        AnsiColorPalette.$init$(this);
        this.testFrameworkFilter = Pattern.compile("\\s+at (sbt\\.|org\\.scalatest\\.|wvlet\\.airspec\\.).*");
        this.DEFAULT_STACKTRACE_FILTER = (Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)LogFormatter$.$anonfun$DEFAULT_STACKTRACE_FILTER$1(line));
        this.stackTraceFilter = this.DEFAULT_STACKTRACE_FILTER();
    }
}

