/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.clustering;

import com.google.inject.Injector;
import com.mulesoft.agent.domain.cluster.ClusterMember;
import com.mulesoft.agent.domain.cluster.ClusterMembership;
import com.mulesoft.agent.domain.cluster.ClusterMembershipChangeAction;
import com.mulesoft.agent.domain.cluster.ClusterMembershipChangeNotification;
import com.mulesoft.agent.domain.cluster.PrimaryNodeNotification;
import com.mulesoft.agent.exception.AgentClusteringException;
import com.mulesoft.agent.exception.RuntimeRestartException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.ClusteringService;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.RuntimeVersionService;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterCoreExtension;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterMemberInfo;
import com.mulesoft.mule.runtime.module.cluster.api.ClusteringTicket;
import com.mulesoft.mule.runtime.module.cluster.api.notification.ClusterMembershipEvent;
import com.mulesoft.mule.runtime.module.cluster.api.notification.ClusterMembershipListener;
import com.mulesoft.mule.runtime.module.cluster.api.notification.PrimaryClusterNodeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.container.api.MuleCoreExtensionDependency;

@Named(value="mule.agent.clustering.service")
@Singleton
public class AgentClusteringService
extends ConfigurableAgentService
implements ClusteringService,
PrimaryClusterNodeListener,
ClusterMembershipListener,
Initialisable {
    private static final Logger LOGGER = LogManager.getLogger(AgentClusteringService.class);
    private ClusterCoreExtension clusterCoreExtension;
    private String listenerRegistrationId;
    private List<ClusterMember> clusterMembers = new LinkedList<ClusterMember>();
    AdministrationService administrationService;
    @Inject
    List<InternalMessageHandler<PrimaryNodeNotification>> primaryNodeInternalHandlers;
    @Inject
    List<InternalMessageHandler<ClusterMembershipChangeNotification>> membershipChangeInternalHandlers;
    @Inject
    private RuntimeVersionService runtimeVersionService;
    @Inject
    private Injector injector;

    public void initialise() {
        this.administrationService = (AdministrationService)this.injector.getInstance(AdministrationService.class);
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
        if (this.listenerRegistrationId != null) {
            this.clusterCoreExtension.unregisterClusterMembershipListener(this.listenerRegistrationId);
        }
    }

    public void addToCluster(ClusterMembership clusterMembership) {
        LOGGER.info("Adding the Mule runtime to the Cluster: Id: {} - Is Multicast?: {} - Node Number: {} - Other Nodes IPs: {} - Hazelcast Port: {}", (Object)clusterMembership.getClusterId(), (Object)clusterMembership.isMulticastEnabled(), (Object)clusterMembership.getNodeNumber(), (Object)AgentClusteringService.joinIPs(clusterMembership.getNodeIPs()), (Object)clusterMembership.getClusteringPort());
        this.checkClusterSupport();
        if (!clusterMembership.isMulticastEnabled() && (clusterMembership.getNodeIPs() == null || clusterMembership.getNodeIPs().isEmpty())) {
            throw new IllegalArgumentException("Node IP addresses need to be provided when multicast is disabled");
        }
        try {
            this.clusterCoreExtension.putClusteringTicket(this.createClusteringTicket(clusterMembership));
            this.administrationService.restartRuntime();
        }
        catch (MuleRuntimeException e) {
            throw new AgentClusteringException("Cluster descriptor file could not be written.", e.getCause());
        }
        catch (RuntimeRestartException e) {
            throw new AgentClusteringException("Could not restart the server.", e.getCause());
        }
    }

    public void removeFromCluster() {
        LOGGER.info("Removing the Mule runtime from the Cluster.");
        this.checkClusterSupport();
        if (!this.isClustered()) {
            throw new UnsupportedOperationException("The server is not part of a cluster so it can not be removed from it");
        }
        try {
            this.clusterCoreExtension.removeClusteringTicket();
            this.administrationService.restartRuntime();
        }
        catch (MuleRuntimeException e) {
            throw new AgentClusteringException("Cluster descriptor file could not be read.", e.getCause());
        }
        catch (RuntimeRestartException e) {
            throw new AgentClusteringException("Could not restart the server.", e.getCause());
        }
    }

    public boolean isClustered() {
        this.checkClusterSupport();
        try {
            return this.clusterCoreExtension.getClusteringTicket() != null;
        }
        catch (MuleRuntimeException e) {
            return false;
        }
    }

    public ClusterMembership getClusterMembership() {
        if (this.isClustered()) {
            try {
                ClusteringTicket clusteringTicket = this.clusterCoreExtension.getClusteringTicket();
                ClusterMemberInfo clusterMemberInfo = this.clusterCoreExtension.getClusterMemberInfo();
                return new ClusterMembership(clusteringTicket.getClusterId(), clusteringTicket.getNodeNumber(), clusterMemberInfo.getUuid(), clusteringTicket.isMulticastEnabled(), clusterMemberInfo.isPrimary(), clusterMemberInfo.getHostAddress(), AgentClusteringService.splitIPs(clusteringTicket.getNodeIPs()), Integer.valueOf(clusterMemberInfo.getPort()));
            }
            catch (MuleRuntimeException e) {
                LOGGER.error("Unexpected error retrieving clustering ticket from Mule");
                return null;
            }
        }
        throw new AgentClusteringException("This server instance is not part of a cluster");
    }

    public List<ClusterMember> getCurrentClusterMembers() {
        if (this.isClustered()) {
            return this.clusterMembers;
        }
        throw new AgentClusteringException("This server instance is not part of a cluster");
    }

    public void onNotification() {
        for (InternalMessageHandler<PrimaryNodeNotification> primaryNodeInternalHandler : this.primaryNodeInternalHandlers) {
            primaryNodeInternalHandler.handle((Object)new PrimaryNodeNotification());
        }
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        ArrayList<InternalMessageHandler> handlerList = new ArrayList<InternalMessageHandler>(this.primaryNodeInternalHandlers);
        return handlerList;
    }

    public void init(Set<ClusterMemberInfo> membersInfo) {
        for (ClusterMemberInfo member : membersInfo) {
            this.clusterMembers.add(new ClusterMember(member.getUuid(), member.getHostAddress(), member.getPort()));
        }
    }

    public void memberAdded(ClusterMembershipEvent membershipEvent) {
        LOGGER.info("Adding member {} to the cluster.", (Object)membershipEvent);
        ClusterMemberInfo member = membershipEvent.getMemberInfo();
        ClusterMember clusterMember = new ClusterMember(member.getUuid(), member.getHostAddress(), member.getPort());
        this.clusterMembers.add(clusterMember);
        for (InternalMessageHandler<ClusterMembershipChangeNotification> membershipChangeInternalHandler : this.membershipChangeInternalHandlers) {
            membershipChangeInternalHandler.handle((Object)new ClusterMembershipChangeNotification(ClusterMembershipChangeAction.ADDED, clusterMember));
        }
    }

    public void memberRemoved(ClusterMembershipEvent membershipEvent) {
        LOGGER.info("Removing member {} from the cluster.", (Object)membershipEvent);
        ClusterMemberInfo member = membershipEvent.getMemberInfo();
        ClusterMember clusterMember = new ClusterMember(member.getUuid(), member.getHostAddress(), member.getPort());
        this.clusterMembers.remove(clusterMember);
        for (InternalMessageHandler<ClusterMembershipChangeNotification> membershipChangeInternalHandler : this.membershipChangeInternalHandlers) {
            membershipChangeInternalHandler.handle((Object)new ClusterMembershipChangeNotification(ClusterMembershipChangeAction.REMOVED, clusterMember));
        }
    }

    @MuleCoreExtensionDependency
    public void setClusterCoreExtension(ClusterCoreExtension clusterCoreExtension) {
        this.clusterCoreExtension = clusterCoreExtension;
        clusterCoreExtension.registerPrimaryNodeListener((PrimaryClusterNodeListener)this);
        this.listenerRegistrationId = clusterCoreExtension.registerClusterMembershipListener((ClusterMembershipListener)this);
    }

    private static String joinIPs(List<String> ipList) {
        if (ipList == null || ipList.isEmpty()) {
            return null;
        }
        return ipList.toString().replace("[", "").replace("]", "").replace(", ", ",");
    }

    private static List<String> splitIPs(String ipString) {
        if (ipString == null) {
            return new LinkedList<String>();
        }
        return Arrays.asList(ipString.split(","));
    }

    private void checkClusterSupport() throws AgentClusteringException {
        if (this.clusterCoreExtension == null) {
            LOGGER.warn("Clustering is not supported for this server instance");
            throw new AgentClusteringException("Clustering is not supported for this server instance. Please contact MuleSoft Support.");
        }
    }

    private ClusteringTicket createClusteringTicket(ClusterMembership clusterMembership) {
        if (this.isPortSetAndAvailable(clusterMembership.getClusteringPort()) && this.runtimeVersionService.supportsClusteringPort()) {
            return new ClusteringTicket(clusterMembership.getClusterId(), clusterMembership.getNodeNumber(), 0, AgentClusteringService.joinIPs(clusterMembership.getNodeIPs()), null, clusterMembership.isMulticastEnabled(), clusterMembership.getClusteringPort());
        }
        return new ClusteringTicket(clusterMembership.getClusterId(), clusterMembership.getNodeNumber(), 0, AgentClusteringService.joinIPs(clusterMembership.getNodeIPs()), null, clusterMembership.isMulticastEnabled());
    }

    private boolean isPortSetAndAvailable(Integer port) {
        if (port == null) {
            return false;
        }
        Integer currentClusteringPort = this.getCurrentClusteringPort();
        if (currentClusteringPort != null && currentClusteringPort.equals(port)) {
            return true;
        }
        if (!this.administrationService.isPortAvailable(port.intValue())) {
            LOGGER.info("Port {} isn't open or accessible. Hazelcast's port autoincrement will be enabled.", (Object)port);
            return false;
        }
        return true;
    }

    private Integer getCurrentClusteringPort() {
        try {
            ClusteringTicket currentClusteringTicket = this.clusterCoreExtension.getClusteringTicket();
            return currentClusteringTicket == null ? null : currentClusteringTicket.getTcpInboundPort();
        }
        catch (MuleRuntimeException e) {
            LOGGER.warn("Couldn't retrieve the current clustering ticket. Error: {}.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            return null;
        }
    }
}

