/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tracking.transformers;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.mulesoft.agent.domain.tracking.FlowSourceEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tooling.event.model.DataTypeModel;
import org.mule.tooling.event.model.ErrorModel;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;

public final class MuleEventTransformer {
    private static final Logger LOGGER = LogManager.getLogger(MuleEventTransformer.class);
    static final String EMPTY_PAYLOAD = "Empty Payload";
    static final String EXCLUDED_PAYLOAD = "Payload Excluded";
    private static final String JSON_DW_TRANSFORMATION = "output application/json\n---\npayload";
    private static final String DW_TRANSFORMATION = "output application/dw ignoreSchema=true\n---\npayload";
    private static final String DW_WITH_MAX_COLLECTIONS_TRANSFORMATION = "output application/dw ignoreSchema=true, maxCollectionSize=%s\n---\npayload";
    private static final String PAYLOAD_ID = "payload";
    private static final List<MediaType> STRING_REPRESENTABLE_MIMETYPES = new ArrayList<MediaType>(Arrays.asList(MediaType.create((String)"application", (String)"javascript"), MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.create((String)"application", (String)"csv"), MediaType.create((String)"application", (String)"rtf"), MediaType.create((String)"application", (String)"vnd.mozilla.xul+xml"), MediaType.create((String)"application", (String)"x-csh"), MediaType.create((String)"application", (String)"x-sh"), MediaType.create((String)"application", (String)"xml+html"), MediaType.create((String)"application", (String)"xml"), MediaType.create((String)"image", (String)"svg+xml"), MediaType.create((String)"text", (String)"calendar"), MediaType.create((String)"text", (String)"css"), MediaType.create((String)"text", (String)"csv"), MediaType.HTML, MediaType.XML, MediaType.TEXT));

    public static FlowSourceEvent toFlowSourceEvent(String applicationName, PipelineMessageNotification notification) {
        try {
            Message message = notification.getEvent().getMessage();
            FlowSourceEvent flowSourceEvent = new FlowSourceEvent();
            flowSourceEvent.setApplicationName(applicationName);
            flowSourceEvent.setFlowName(notification.getEvent().getContext().getOriginatingLocation().getRootContainerName());
            flowSourceEvent.setPayload(MuleEventTransformer.clonePayload(message));
            return flowSourceEvent;
        }
        catch (Throwable e) {
            LOGGER.error("Could not store your message as it is not serializable");
            return new FlowSourceEvent();
        }
    }

    public static String getPayloadAsString(Message muleMessage, boolean forcePayloadInclusion, boolean isPayloadExcluded) {
        if (isPayloadExcluded) {
            return EXCLUDED_PAYLOAD;
        }
        if (muleMessage.getPayload().getDataType() != null && STRING_REPRESENTABLE_MIMETYPES.contains(muleMessage.getPayload().getDataType().getMediaType()) || forcePayloadInclusion) {
            TypedValue payload = muleMessage.getPayload();
            if (payload.getValue() != null) {
                return payload.getValue().toString();
            }
            return EMPTY_PAYLOAD;
        }
        TypedValue payload = muleMessage.getPayload();
        if (payload.getValue() != null) {
            return muleMessage.getPayload().getValue().getClass().getName();
        }
        return EMPTY_PAYLOAD;
    }

    public static EventModel getEventModel(EnrichedServerNotification notification, ExpressionLanguage expressionLanguage, long maxPayloadSize, long maxCollectionSize, boolean markSuccessful, Charset defaultEncoding, boolean useDataWeaveFormatForPojo) {
        if (notification.getEvent().getMessage() == null) {
            return null;
        }
        return EventModel.builder().withMessage(MuleEventTransformer.buildMessageModel(notification.getEvent().getMessage(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, useDataWeaveFormatForPojo)).withVariables(MuleEventTransformer.toTypedValueVariables(notification.getEvent().getVariables(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, useDataWeaveFormatForPojo)).withError(MuleEventTransformer.getErrorModel(notification.getEvent().getError(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, useDataWeaveFormatForPojo), markSuccessful).build();
    }

    public static EventModel getEventModel(EnrichedServerNotification notification, ExpressionLanguage expressionLanguage, long maxPayloadSize, long maxCollectionSize, Charset defaultEncoding) {
        return MuleEventTransformer.getEventModel(notification, expressionLanguage, maxPayloadSize, maxCollectionSize, false, defaultEncoding, false);
    }

    private static MessageModel buildMessageModel(Message message, long maxPayloadSize, long maxCollectionSize, ExpressionLanguage expressionLanguage, Charset defaultEncoding, boolean useDataWeaveFormatForPojo) {
        if (message == null) {
            return null;
        }
        return MessageModel.builder().withAttributes(MuleEventTransformer.transformTypedValue(message.getAttributes(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, useDataWeaveFormatForPojo)).withPayload(MuleEventTransformer.transformTypedValue(message.getPayload(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, useDataWeaveFormatForPojo)).build();
    }

    private static ErrorModel getErrorModel(Optional<Error> errorOptional, long maxPayloadSize, long maxCollectionSize, ExpressionLanguage expressionLanguage, Charset defaultEncoding, boolean useDataWeaveFormatForPojo) {
        return errorOptional.map(error -> ErrorModel.builder().withDescription(error.getDescription()).withDetailedDescription(error.getDetailedDescription()).withType(error.getErrorType().getNamespace() + ":" + error.getErrorType().getIdentifier()).withExceptionType(error.getCause().getClass().getName()).withMessage(MuleEventTransformer.buildMessageModel(error.getErrorMessage(), maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, useDataWeaveFormatForPojo)).build()).orElse(null);
    }

    private static byte[] createByteArrayFromInputStream(InputStream input) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)input, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not close stream", (Throwable)e);
            }
        }
    }

    private static TypedValueModel transformTypedValue(TypedValue typedValue, long maxPayloadSize, long maxCollectionSize, ExpressionLanguage expressionLanguage, Charset defaultEncoding, boolean useDataWeaveFormatForPojo) {
        if (typedValue == null) {
            return null;
        }
        TypedValueModel.Builder typedValueModelBuilder = TypedValueModel.builder();
        if (typedValue.getValue() == null) {
            typedValueModelBuilder.withDataType(DataTypeModel.builder().withType(typedValue.getDataType().getType().getName()).withMediaType(typedValue.getDataType().getMediaType().toRfcString()).build());
        } else {
            try {
                byte[] content;
                Charset outputEncoding = typedValue.getDataType().getMediaType().getCharset().orElse(defaultEncoding);
                typedValueModelBuilder.withDataType(DataTypeModel.builder().withType(typedValue.getDataType().getType().getName()).withMediaType(typedValue.getDataType().getMediaType().toRfcString()).build());
                if (DataType.CURSOR_STREAM_PROVIDER.isCompatibleWith(typedValue.getDataType()) || typedValue.getValue() instanceof CursorStreamProvider) {
                    content = MuleEventTransformer.createByteArrayFromInputStream(MuleEventTransformer.limit((InputStream)((CursorStreamProvider)typedValue.getValue()).openCursor(), maxPayloadSize));
                } else if (DataType.INPUT_STREAM.isCompatibleWith(typedValue.getDataType()) || typedValue.getValue() instanceof InputStream) {
                    LOGGER.info(String.format("%s cannot be consumed there tracking event won't have a preview for this typedValue", typedValue.getDataType()));
                    typedValueModelBuilder.withDataType(DataTypeModel.builder().withType(typedValue.getDataType().getType().getName()).withMediaType(MediaType.create((String)typedValue.getDataType().getMediaType().getPrimaryType(), (String)typedValue.getDataType().getMediaType().getSubType(), (Charset)outputEncoding).toRfcString()).build());
                    content = typedValue.getValue().getClass().getName().getBytes(outputEncoding);
                } else if (DataType.BYTE_ARRAY.isCompatibleWith(typedValue.getDataType()) && typedValue.getValue() instanceof byte[]) {
                    content = MuleEventTransformer.copyOf((byte[])typedValue.getValue(), Long.valueOf(maxPayloadSize).intValue());
                } else if (DataType.OBJECT.isCompatibleWith(typedValue.getDataType()) && typedValue.getValue() instanceof String) {
                    typedValueModelBuilder.withDataType(DataTypeModel.builder().withType(typedValue.getDataType().getType().getName()).withMediaType(MediaType.create((String)typedValue.getDataType().getMediaType().getPrimaryType(), (String)typedValue.getDataType().getMediaType().getSubType(), (Charset)outputEncoding).toRfcString()).build());
                    content = MuleEventTransformer.copyOf(String.valueOf(typedValue.getValue()).getBytes(outputEncoding), Long.valueOf(maxPayloadSize).intValue());
                } else {
                    typedValueModelBuilder.withDataType(DataTypeModel.builder().withMediaType(MediaType.create((String)"application", (String)(useDataWeaveFormatForPojo ? "dw" : "json"), (Charset)outputEncoding).toRfcString()).withType(DataType.STRING.getType().getName()).build());
                    BindingContext.Builder bindingBuilder = BindingContext.builder();
                    bindingBuilder.addBinding(PAYLOAD_ID, typedValue);
                    String script = MuleEventTransformer.getDataWeaveScript(useDataWeaveFormatForPojo, maxCollectionSize);
                    TypedValue weaveResult = expressionLanguage.evaluate(script, bindingBuilder.build());
                    content = DataType.CURSOR_STREAM_PROVIDER.isCompatibleWith(weaveResult.getDataType()) || weaveResult.getValue() instanceof CursorStreamProvider ? MuleEventTransformer.createByteArrayFromInputStream((InputStream)((CursorStreamProvider)weaveResult.getValue()).openCursor()) : String.valueOf(weaveResult.getValue()).getBytes(outputEncoding);
                }
                MuleEventTransformer.setTypedValueModelContent(maxPayloadSize, typedValueModelBuilder, content);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
                return typedValueModelBuilder.withContent(e.getMessage().getBytes()).build();
            }
        }
        return typedValueModelBuilder.build();
    }

    private static String getDataWeaveScript(boolean useDataWeaveFormatForPojo, long maxCollectionSize) {
        if (!useDataWeaveFormatForPojo) {
            return JSON_DW_TRANSFORMATION;
        }
        if (maxCollectionSize != -1L) {
            return String.format(DW_WITH_MAX_COLLECTIONS_TRANSFORMATION, maxCollectionSize);
        }
        return DW_TRANSFORMATION;
    }

    private static InputStream limit(InputStream inputStream, long limit) {
        if (limit > 0L) {
            return ByteStreams.limit((InputStream)inputStream, (long)limit);
        }
        return inputStream;
    }

    private static byte[] copyOf(byte[] content, long newLength) {
        if (newLength > 0L && (long)content.length > newLength) {
            return Arrays.copyOf(content, Long.valueOf(newLength).intValue());
        }
        return content;
    }

    private static void setTypedValueModelContent(long maxPayloadSize, TypedValueModel.Builder typedValueModelBuilder, byte[] content) {
        if (maxPayloadSize != -1L && (long)content.length == maxPayloadSize) {
            typedValueModelBuilder.withTruncated(true);
            typedValueModelBuilder.withContent(content);
        } else {
            typedValueModelBuilder.withContent(content);
        }
    }

    private static Map<String, TypedValueModel> toTypedValueVariables(Map<String, TypedValue<?>> variables, long maxPayloadSize, long maxCollectionSize, ExpressionLanguage expressionLanguage, Charset defaultEncoding, boolean useDataWeaveFormatForPojo) {
        HashMap<String, TypedValueModel> result = new HashMap<String, TypedValueModel>();
        variables.forEach((name, value) -> result.put((String)name, MuleEventTransformer.transformTypedValue(value, maxPayloadSize, maxCollectionSize, expressionLanguage, defaultEncoding, useDataWeaveFormatForPojo)));
        return result;
    }

    public static Object clonePayload(Message muleMessage) {
        return muleMessage.getPayload();
    }

    private static Object cloneObject(ClassLoader executionClassLoader, MuleMessageSupplier muleMessageSupplier, String encoding) {
        try {
            Object clonedPayload = null;
            Object payload = muleMessageSupplier.getOriginal();
            if (payload instanceof Serializable) {
                clonedPayload = MuleEventTransformer.clone((Serializable)payload, executionClassLoader);
            } else if (payload instanceof InputStream) {
                clonedPayload = MuleEventTransformer.cloneStream(muleMessageSupplier, encoding);
            } else if (payload instanceof Reader) {
                clonedPayload = MuleEventTransformer.cloneReader(muleMessageSupplier, encoding);
            } else {
                Gson gson = new Gson();
                String s = gson.toJson(payload);
                clonedPayload = gson.fromJson(s, payload.getClass());
            }
            return clonedPayload;
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not clone the mule message", e);
        }
    }

    private static Reader cloneReader(final MuleMessageSupplier messageSupplier, final String encoding) {
        InputStream clonedStream = MuleEventTransformer.cloneStream(new MuleMessageSupplier(){

            @Override
            public Object getOriginal() {
                return new ReaderInputStream((Reader)messageSupplier.getOriginal(), encoding);
            }

            @Override
            public void changeOriginal(Object o) {
                messageSupplier.changeOriginal(new InputStreamReader((InputStream)o));
            }
        }, encoding);
        return clonedStream == null ? null : new InputStreamReader(clonedStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream cloneStream(MuleMessageSupplier messageSupplier, String encoding) {
        InputStream payload = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            payload = (InputStream)messageSupplier.getOriginal();
            ByteStreams.copy((InputStream)payload, (OutputStream)outputStream);
            String clonedPayload = new String(outputStream.toByteArray(), encoding);
            if (payload.markSupported()) {
                payload.reset();
            }
            if (payload.available() <= 0) {
                messageSupplier.changeOriginal(clonedPayload);
            }
            InputStream inputStream = ByteSource.wrap((byte[])outputStream.toByteArray()).openStream();
            return inputStream;
        }
        catch (IOException e) {
            LOGGER.debug("Exception while cloning stream.", (Throwable)e);
            try {
                ByteSource outputSupplier = ByteSource.wrap((byte[])outputStream.toByteArray());
                ByteSource inputSupplier = ByteSource.wrap((byte[])ByteStreams.toByteArray((InputStream)payload));
                ByteSource join = ByteSource.concat((ByteSource[])new ByteSource[]{outputSupplier, inputSupplier});
                messageSupplier.changeOriginal(join.openStream());
            }
            catch (IOException e1) {
                LOGGER.error("Unable to clone stream. Error: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e1));
                LOGGER.debug("Exception during fallback after failure to clone stream.", (Throwable)e1);
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            try {
                if (payload != null) {
                    payload.close();
                }
                outputStream.close();
            }
            catch (IOException e) {
                LOGGER.info("Exception attempting to close stream after cloning payload. Error: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
        }
    }

    private static <T extends Serializable> T clone(T obj, ClassLoader classLoader) {
        byte[] objectData = SerializationUtils.serialize(obj);
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        ClassLoaderObjectInputStream in = null;
        try {
            in = new ClassLoaderObjectInputStream(classLoader, (InputStream)bais);
            Serializable serializable = (Serializable)in.readObject();
            return (T)serializable;
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.debug("Error closing stream.", (Throwable)ex);
            }
        }
    }

    private static interface MuleMessageSupplier {
        public Object getOriginal();

        public void changeOriginal(Object var1);
    }
}

