/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tracking.listeners;

import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.tracking.TrackedApplication;
import com.mulesoft.agent.services.tracking.TrackedFlow;
import com.mulesoft.agent.services.tracking.TrackingLevelUtils;
import com.mulesoft.agent.services.tracking.transformers.MuleEventTransformer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.tooling.event.model.EventModel;

public abstract class AgentTrackingListener<T extends EnrichedServerNotification>
implements NotificationListener<T> {
    private static final Logger LOGGER = LogManager.getLogger(AgentTrackingListener.class);
    protected TrackedApplication trackedApplication;
    private DeploymentService deploymentService;
    protected long maxPayloadSize;
    private long maxCollectionSize = -1L;
    private boolean globalUseDataWeaveFormatForPojo;
    protected Map<String, InternalMessageHandler<AgentTrackingNotification>> notificationHandlers;

    public AgentTrackingListener(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> notificationHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
        this.trackedApplication = trackedApplication;
        this.deploymentService = deploymentService;
        this.notificationHandlers = notificationHandlers;
        this.maxPayloadSize = maxPayloadSize;
        this.maxCollectionSize = maxCollectionSize;
        this.globalUseDataWeaveFormatForPojo = globalUseDataWeaveFormatForPojo;
    }

    public void onNotification(T notification) {
        TrackedFlow trackedFlow = this.getTrackedFlow(this.getSourceFlowName(notification));
        if (trackedFlow == null || this.flowIsTrackingNotification(trackedFlow, notification)) {
            for (InternalMessageHandler<AgentTrackingNotification> notificationHandler : this.notificationHandlers.values()) {
                notificationHandler.handle((Object)this.transformNotification(notification));
            }
        }
    }

    protected String getSourceFlowName(T notification) {
        return notification.getEvent().getContext().getOriginatingLocation().getRootContainerName();
    }

    protected abstract AgentTrackingNotification transformNotification(T var1);

    protected Application getApplication() {
        Application application = this.deploymentService.findApplication(this.trackedApplication.getAppName());
        if (application == null) {
            throw new IllegalStateException(String.format("Application for name '%s' is not available, cannot process notification", this.trackedApplication.getApplicationName()));
        }
        return application;
    }

    protected ExpressionLanguage getExpressionLanguage() {
        return (ExpressionLanguage)this.getApplication().getRegistry().lookupByName("_muleExpressionManager").orElseThrow(() -> new IllegalArgumentException(String.format("Could not retrieve Expression Language for application %s", this.trackedApplication.getAppName())));
    }

    protected Charset getApplicationDefaultEncoding() {
        return SystemUtils.getDefaultEncoding((MuleContext)((MuleContext)this.deploymentService.findApplication(this.trackedApplication.getAppName()).getRegistry().lookupByName("_muleContext").orElseThrow(() -> new IllegalStateException(String.format("Could not retrieve Mule Context for application %s", this.trackedApplication.getAppName())))));
    }

    protected ConfigurationComponentLocator getConfigurationComponentLocator() {
        return (ConfigurationComponentLocator)this.deploymentService.findApplication(this.trackedApplication.getAppName()).getRegistry().lookupByName("_muleConfigurationComponentLocator").orElseThrow(() -> new IllegalArgumentException(String.format("Could not retrieve configurationcomponent locator for application %s.", this.trackedApplication.getAppName())));
    }

    protected TrackedFlow getTrackedFlow(String flowName) {
        if (this.trackedApplication.hasTrackedFlows()) {
            for (TrackedFlow trackedFlow : this.trackedApplication.getTrackedFlows()) {
                if (!trackedFlow.getFlowName().equals(flowName)) continue;
                return trackedFlow;
            }
        }
        return null;
    }

    protected boolean flowIsTrackingNotification(TrackedFlow trackedFlow, T notification) {
        return TrackingLevelUtils.levelHandlesNotification(trackedFlow.getTrackingLevel(), notification);
    }

    public EventModel getEventForTrackingEvent(T notification) {
        return this.getEventForTrackingEvent(notification, false);
    }

    public EventModel getEventForTrackingEvent(T notification, boolean markSuccessful) {
        boolean isUseMuleEvent;
        TrackedFlow flow = this.getTrackedFlow(this.getSourceFlowName(notification));
        boolean isPayloadExcluded = flow != null && flow.isPayloadExcluded() || this.trackedApplication.getPayloadExcluded() != false;
        boolean bl = isUseMuleEvent = flow != null && flow.isUseEventModel() || this.trackedApplication.getUseEventModel() != false;
        if (isPayloadExcluded || !isUseMuleEvent) {
            return null;
        }
        return MuleEventTransformer.getEventModel(notification, this.getExpressionLanguage(), this.maxPayloadSize, this.maxCollectionSize, markSuccessful, this.getApplicationDefaultEncoding(), this.globalUseDataWeaveFormatForPojo);
    }

    public String getMuleMessageForTrackingEvent(T notification) {
        boolean isUseMuleEvent;
        Message muleMessage;
        Message message = muleMessage = notification.getEvent() != null ? notification.getEvent().getMessage() : null;
        if (muleMessage == null) {
            return null;
        }
        TrackedFlow flow = this.getTrackedFlow(this.getSourceFlowName(notification));
        boolean bl = isUseMuleEvent = flow != null && flow.isUseEventModel() || this.trackedApplication.getUseEventModel() != false;
        if (isUseMuleEvent) {
            return null;
        }
        boolean isPayloadExcluded = flow != null && flow.isPayloadExcluded() || this.trackedApplication.getPayloadExcluded() != false;
        boolean forcePayloadInclusion = flow != null && flow.isPayloadInclusionForced() || this.trackedApplication.getPayloadInclusionForced() != false;
        return MuleEventTransformer.getPayloadAsString(muleMessage, forcePayloadInclusion, isPayloadExcluded);
    }

    public String getMuleEventContextId(T notification) {
        return notification.getEvent() != null ? notification.getEvent().getContext().getId() : "";
    }

    public String getMuleEventCorrelationId(T notification) {
        return notification.getEvent() != null ? notification.getEvent().getContext().getCorrelationId() : "";
    }
}

