/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tracking.listeners;

import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.domain.tracking.FlowSourceEvent;
import com.mulesoft.agent.domain.tracking.ReplayLevel;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.tracking.TrackedApplication;
import com.mulesoft.agent.services.tracking.TrackedFlow;
import com.mulesoft.agent.services.tracking.listeners.AgentTrackingListener;
import com.mulesoft.agent.services.tracking.transformers.MuleEventTransformer;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.notification.PipelineMessageNotificationListener;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.module.deployment.api.DeploymentService;

public class AgentPipelineNotificationListener
extends AgentTrackingListener<PipelineMessageNotification>
implements PipelineMessageNotificationListener<PipelineMessageNotification> {
    private static final Logger LOGGER = LogManager.getLogger(AgentPipelineNotificationListener.class);
    private Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers;

    public AgentPipelineNotificationListener(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> notificationHandlers, Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
        super(trackedApplication, deploymentService, notificationHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo);
        this.flowSourceEventHandlers = flowSourceEventHandlers;
    }

    @Override
    public void onNotification(PipelineMessageNotification notification) {
        TrackedFlow trackedFlow = this.getTrackedFlow(this.getSourceFlowName(notification));
        ReplayLevel replayLevel = this.getReplayLevel(this.getSourceFlowName(notification));
        if (trackedFlow == null || this.flowIsTrackingNotification(trackedFlow, notification)) {
            for (InternalMessageHandler notificationHandler : this.notificationHandlers.values()) {
                notificationHandler.handle((Object)this.transformNotification(notification));
            }
            if (notification.getAction().getActionId() == 1801 && (replayLevel == ReplayLevel.ALL || this.isFlow(notification, replayLevel))) {
                FlowSourceEvent flowSourceEvent = MuleEventTransformer.toFlowSourceEvent(this.trackedApplication.getAppName(), notification);
                for (InternalMessageHandler<FlowSourceEvent> flowSourceEventHandler : this.flowSourceEventHandlers.values()) {
                    flowSourceEventHandler.handle((Object)flowSourceEvent);
                }
            }
        }
    }

    private boolean isFlow(PipelineMessageNotification notification, ReplayLevel replayLevel) {
        if (replayLevel != ReplayLevel.SOURCED) {
            return false;
        }
        Component component = (Component)this.getConfigurationComponentLocator().find(Location.builder().globalName(notification.getEvent().getContext().getOriginatingLocation().getRootContainerName()).build()).get();
        return component instanceof Flow;
    }

    @Override
    public AgentTrackingNotification transformNotification(PipelineMessageNotification notification) {
        try {
            return new AgentTrackingNotification.TrackingNotificationBuilder().application(this.trackedApplication.getAppName()).notificationType(notification.getEventName()).action(notification.getActionName()).timestamp(notification.getTimestamp()).source(notification.getResourceIdentifier()).resourceIdentifier(notification.getResourceIdentifier()).event(this.getEventForTrackingEvent(notification)).muleMessage(this.getMuleMessageForTrackingEvent(notification)).correlationId(this.getMuleEventCorrelationId(notification)).transactionId(this.getMuleEventContextId(notification)).build();
        }
        catch (Exception e) {
            LOGGER.warn("Error processing the PipelineMessageNotification: '{}'. Error: {}", (Object)notification, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            throw e;
        }
    }

    private ReplayLevel getReplayLevel(String flowName) {
        if (this.trackedApplication.hasTrackedFlows()) {
            for (TrackedFlow trackedFlow : this.trackedApplication.getTrackedFlows()) {
                if (!trackedFlow.getFlowName().equals(flowName)) continue;
                return trackedFlow.getReplayLevel();
            }
        }
        return this.trackedApplication.getReplayLevel();
    }
}

