/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tracking.listeners;

import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.tracking.TrackedApplication;
import com.mulesoft.agent.services.tracking.listeners.AgentTrackingListener;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.MessageProcessorNotificationListener;
import org.mule.runtime.module.deployment.api.DeploymentService;

public class AgentMessageProcessorNotificationListener
extends AgentTrackingListener<MessageProcessorNotification>
implements MessageProcessorNotificationListener<MessageProcessorNotification> {
    private static final Logger LOGGER = LogManager.getLogger(AgentMessageProcessorNotificationListener.class);

    public AgentMessageProcessorNotificationListener(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> notificationHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
        super(trackedApplication, deploymentService, notificationHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo);
    }

    @Override
    public AgentTrackingNotification transformNotification(MessageProcessorNotification notification) {
        try {
            return new AgentTrackingNotification.TrackingNotificationBuilder().application(this.trackedApplication.getAppName()).notificationType(notification.getEventName()).action(notification.getActionName()).timestamp(notification.getTimestamp()).source(notification.getComponent().getClass().getSimpleName()).resourceIdentifier(notification.getResourceIdentifier()).event(this.getEventForTrackingEvent(notification, notification.getException() != null)).muleMessage(this.getMuleMessageForTrackingEvent(notification)).correlationId(this.getMuleEventCorrelationId(notification)).transactionId(this.getMuleEventContextId(notification)).annotations(Arrays.asList(notification.getComponent().getClass().getAnnotations())).componentLocation(notification.getComponent().getLocation()).build();
        }
        catch (Exception e) {
            LOGGER.warn("Error processing the MessageProcessorNotification: '{}'. Error: {}", (Object)notification, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            throw e;
        }
    }
}

