/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tracking.listeners;

import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.tracking.TrackedApplication;
import com.mulesoft.agent.services.tracking.listeners.AgentTrackingListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.notification.ExceptionNotification;
import org.mule.runtime.api.notification.ExceptionNotificationListener;
import org.mule.runtime.module.deployment.api.DeploymentService;

public class AgentExceptionNotificationListener
extends AgentTrackingListener<ExceptionNotification>
implements ExceptionNotificationListener {
    private static final Logger LOGGER = LogManager.getLogger(AgentExceptionNotificationListener.class);

    public AgentExceptionNotificationListener(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> notificationHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
        super(trackedApplication, deploymentService, notificationHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo);
    }

    @Override
    public AgentTrackingNotification transformNotification(ExceptionNotification notification) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            notification.getException().printStackTrace(printWriter);
            AgentTrackingNotification.TrackingNotificationBuilder builder = new AgentTrackingNotification.TrackingNotificationBuilder().application(this.trackedApplication.getAppName()).notificationType(notification.getEventName()).action(notification.getActionName()).timestamp(notification.getTimestamp()).source(stringWriter.toString()).resourceIdentifier(notification.getResourceIdentifier()).event(this.getEventForTrackingEvent(notification, true)).muleMessage(this.getMuleMessageForTrackingEvent(notification)).correlationId(this.getMuleEventCorrelationId(notification)).transactionId(this.getMuleEventContextId(notification));
            if (notification.getComponent() != null && notification.getComponent().getLocation() != null) {
                builder.componentLocation(notification.getComponent().getLocation());
            }
            return builder.build();
        }
        catch (Exception e) {
            LOGGER.warn("Error processing the ExceptionNotification: '{}'. Error: {}", (Object)notification, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            throw e;
        }
    }
}

