/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tracking.listeners;

import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.tracking.TrackedApplication;
import com.mulesoft.agent.services.tracking.listeners.AgentTrackingListener;
import com.mulesoft.mule.runtime.tracking.api.event.EventNotification;
import com.mulesoft.mule.runtime.tracking.api.event.EventNotificationListener;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.module.deployment.api.DeploymentService;

public class AgentEventNotificationListener
extends AgentTrackingListener<EventNotification>
implements EventNotificationListener<EventNotification> {
    private static final Logger LOGGER = LogManager.getLogger(AgentEventNotificationListener.class);

    public AgentEventNotificationListener(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> notificationHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
        super(trackedApplication, deploymentService, notificationHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo);
    }

    @Override
    public AgentTrackingNotification transformNotification(EventNotification notification) {
        try {
            return new AgentTrackingNotification.TrackingNotificationBuilder().application(this.trackedApplication.getAppName()).notificationType(notification.getEventName()).action(notification.getActionName()).timestamp(notification.getTimestamp()).source(notification.getProcessor().getClass().getSimpleName()).resourceIdentifier(notification.getEvent().getContext().getOriginatingLocation().getRootContainerName()).componentLocation(notification.getComponent().getLocation()).correlationId(this.getMuleEventCorrelationId(notification)).transactionId(this.getMuleEventContextId(notification)).trackingTransactionId(notification.getTransactionId()).event(this.getEventForTrackingEvent(notification)).muleMessage(this.getMuleMessageForTrackingEvent(notification)).customEventProperties(notification.getMetaDatas()).customEventName(notification.getName()).build();
        }
        catch (Exception e) {
            LOGGER.warn("Error processing the EventNotification: '{}'. Error: {}", (Object)notification, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            throw e;
        }
    }
}

