/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tracking;

import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.domain.tracking.FlowSourceEvent;
import com.mulesoft.agent.domain.tracking.TrackingLevel;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.tracking.TrackedApplication;
import com.mulesoft.agent.services.tracking.listeners.AgentAsyncNotificationListener;
import com.mulesoft.agent.services.tracking.listeners.AgentErrorHandlerNotificationListener;
import com.mulesoft.agent.services.tracking.listeners.AgentEventNotificationListener;
import com.mulesoft.agent.services.tracking.listeners.AgentExceptionNotificationListener;
import com.mulesoft.agent.services.tracking.listeners.AgentMessageProcessorNotificationListener;
import com.mulesoft.agent.services.tracking.listeners.AgentPipelineNotificationListener;
import com.mulesoft.agent.services.tracking.listeners.AgentTrackingListener;
import com.mulesoft.agent.services.tracking.listeners.AgentTransactionNotificationListener;
import com.mulesoft.mule.runtime.tracking.api.event.EventNotification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.ErrorHandlerNotification;
import org.mule.runtime.api.notification.ExceptionNotification;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.notification.TransactionNotification;
import org.mule.runtime.module.deployment.api.DeploymentService;

public class TrackingLevelUtils {
    private static Map<TrackingLevel, ListenerFactory> listenerFactories;
    private static Map<TrackingLevel, List<Class>> handledNotificationClasses;
    private static ListenerFactory nullListenerFactory;
    private static ListenerFactory beListenerFactory;
    private static ListenerFactory trackingListenerFactory;
    public static ListenerFactory debugListenerFactory;

    public static List<AgentTrackingListener> getListeners(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> trackingNotificationHandlers, Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
        return listenerFactories.get(trackedApplication.getTrackingLevel()).getListeners(trackedApplication, deploymentService, trackingNotificationHandlers, flowSourceEventHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo);
    }

    public static boolean levelHandlesNotification(TrackingLevel trackingLevel, AbstractServerNotification notification) {
        for (Class handledNotificationClass : handledNotificationClasses.get(trackingLevel)) {
            if (!notification.getClass().equals(handledNotificationClass)) continue;
            return true;
        }
        return false;
    }

    static {
        nullListenerFactory = new ListenerFactory(){

            @Override
            public List<AgentTrackingListener> getListeners(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> trackingNotificationHandlers, Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
                return new ArrayList<AgentTrackingListener>();
            }
        };
        beListenerFactory = new CompoundListenerFactory(nullListenerFactory, new ListenerFactory(){

            @Override
            public List<AgentTrackingListener> getListeners(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> trackingNotificationHandlers, Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
                ArrayList<AgentTrackingListener> listeners = new ArrayList<AgentTrackingListener>();
                listeners.add(new AgentAsyncNotificationListener(trackedApplication, deploymentService, trackingNotificationHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo));
                listeners.add(new AgentPipelineNotificationListener(trackedApplication, deploymentService, trackingNotificationHandlers, flowSourceEventHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo));
                listeners.add(new AgentExceptionNotificationListener(trackedApplication, deploymentService, trackingNotificationHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo));
                listeners.add(new AgentEventNotificationListener(trackedApplication, deploymentService, trackingNotificationHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo));
                return listeners;
            }
        });
        trackingListenerFactory = new CompoundListenerFactory(beListenerFactory, new ListenerFactory(){

            @Override
            public List<AgentTrackingListener> getListeners(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> trackingNotificationHandlers, Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
                ArrayList<AgentTrackingListener> listeners = new ArrayList<AgentTrackingListener>();
                listeners.add(new AgentErrorHandlerNotificationListener(trackedApplication, deploymentService, trackingNotificationHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo));
                listeners.add(new AgentTransactionNotificationListener(trackedApplication, deploymentService, trackingNotificationHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo));
                return listeners;
            }
        });
        debugListenerFactory = new CompoundListenerFactory(trackingListenerFactory, new ListenerFactory(){

            @Override
            public List<AgentTrackingListener> getListeners(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> trackingNotificationHandlers, Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
                ArrayList<AgentTrackingListener> listeners = new ArrayList<AgentTrackingListener>();
                listeners.add(new AgentMessageProcessorNotificationListener(trackedApplication, deploymentService, trackingNotificationHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo));
                return listeners;
            }
        });
        listenerFactories = new HashMap<TrackingLevel, ListenerFactory>();
        handledNotificationClasses = new HashMap<TrackingLevel, List<Class>>();
        listenerFactories.put(TrackingLevel.NONE, nullListenerFactory);
        handledNotificationClasses.put(TrackingLevel.NONE, new LinkedList());
        listenerFactories.put(TrackingLevel.BE, beListenerFactory);
        ArrayList<Class> beHandledNotifications = new ArrayList<Class>();
        beHandledNotifications.add(AsyncMessageNotification.class);
        beHandledNotifications.add(PipelineMessageNotification.class);
        beHandledNotifications.add(ExceptionNotification.class);
        beHandledNotifications.add(EventNotification.class);
        handledNotificationClasses.put(TrackingLevel.BE, beHandledNotifications);
        listenerFactories.put(TrackingLevel.TRACKING, trackingListenerFactory);
        ArrayList<Class> trackingHandledNotifications = new ArrayList<Class>();
        trackingHandledNotifications.add(TransactionNotification.class);
        trackingHandledNotifications.add(ErrorHandlerNotification.class);
        trackingHandledNotifications.addAll(beHandledNotifications);
        handledNotificationClasses.put(TrackingLevel.TRACKING, trackingHandledNotifications);
        listenerFactories.put(TrackingLevel.DEBUG, debugListenerFactory);
        ArrayList<Class> debugHandledNotifications = new ArrayList<Class>();
        debugHandledNotifications.add(MessageProcessorNotification.class);
        debugHandledNotifications.addAll(trackingHandledNotifications);
        handledNotificationClasses.put(TrackingLevel.DEBUG, debugHandledNotifications);
    }

    private static class CompoundListenerFactory
    implements ListenerFactory {
        private ListenerFactory[] factories;

        public CompoundListenerFactory(ListenerFactory ... factories) {
            this.factories = factories;
        }

        @Override
        public List<AgentTrackingListener> getListeners(TrackedApplication trackedApplication, DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> trackingNotificationHandlers, Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers, long maxPayloadSize, long maxCollectionSize, boolean globalUseDataWeaveFormatForPojo) {
            ArrayList<AgentTrackingListener> listeners = new ArrayList<AgentTrackingListener>();
            for (ListenerFactory factory : this.factories) {
                listeners.addAll(factory.getListeners(trackedApplication, deploymentService, trackingNotificationHandlers, flowSourceEventHandlers, maxPayloadSize, maxCollectionSize, globalUseDataWeaveFormatForPojo));
            }
            return listeners;
        }
    }

    private static interface ListenerFactory {
        public List<AgentTrackingListener> getListeners(TrackedApplication var1, DeploymentService var2, Map<String, InternalMessageHandler<AgentTrackingNotification>> var3, Map<String, InternalMessageHandler<FlowSourceEvent>> var4, long var5, long var7, boolean var9);
    }
}

