/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tracking;

import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.domain.tracking.FlowSourceEvent;
import com.mulesoft.agent.domain.tracking.ReplayLevel;
import com.mulesoft.agent.domain.tracking.TrackingLevel;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.tracking.TrackedApplication;
import com.mulesoft.agent.services.tracking.TrackingLevelUtils;
import com.mulesoft.agent.services.tracking.listeners.AgentTrackingListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;

class TrackingDeploymentListener
implements DeploymentListener {
    private static final Logger LOGGER = LogManager.getLogger(TrackingDeploymentListener.class);
    private TrackingLevel globalTrackingLevel;
    private ReplayLevel globalReplayLevel;
    private boolean globalPayloadExclusion;
    private boolean forceGlobalPayloadInclusion;
    private boolean globalUseEventModel;
    private long maxPayloadSize;
    private long maxCollectionSize = -1L;
    private boolean globalUseDataWeaveFormatForPojo;
    private List<TrackedApplication> trackedApplications;
    private DeploymentService deploymentService;
    private Map<String, List<AgentTrackingListener>> registeredListeners = new ConcurrentHashMap<String, List<AgentTrackingListener>>();
    private Map<String, InternalMessageHandler<AgentTrackingNotification>> trackingNotificationHandlers;
    private Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers;

    TrackingDeploymentListener(DeploymentService deploymentService, Map<String, InternalMessageHandler<AgentTrackingNotification>> trackingNotificationHandlers, Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers) {
        this.deploymentService = deploymentService;
        this.trackingNotificationHandlers = trackingNotificationHandlers;
        this.flowSourceEventHandlers = flowSourceEventHandlers;
    }

    void setGlobalTrackingLevel(TrackingLevel globalTrackingLevel) {
        this.globalTrackingLevel = globalTrackingLevel;
    }

    void setGlobalReplayLevel(ReplayLevel globalReplayLevel) {
        this.globalReplayLevel = globalReplayLevel;
    }

    void setGlobalPayloadExclusion(boolean globalPayloadExclusion) {
        this.globalPayloadExclusion = globalPayloadExclusion;
    }

    void setForceGlobalPayloadInclusion(boolean forceGlobalPayloadInclusion) {
        this.forceGlobalPayloadInclusion = forceGlobalPayloadInclusion;
    }

    void setGlobalUseEventModel(boolean globalUseEventModel) {
        this.globalUseEventModel = globalUseEventModel;
    }

    void setMaxPayloadSize(long maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
    }

    void setMaxCollectionSize(long maxCollectionSize) {
        this.maxCollectionSize = maxCollectionSize;
    }

    void setTrackedApplications(TrackedApplication[] trackedApplications) {
        this.trackedApplications = Arrays.asList(trackedApplications);
    }

    void trackApplication(TrackedApplication trackedApplication) {
        for (Application application : this.deploymentService.getApplications()) {
            if (!trackedApplication.getAppName().equals(application.getArtifactName())) continue;
            this.registerListenersForApplication(trackedApplication, application.getRegistry());
        }
    }

    void untrackApplication(String trackedApplication) {
        Application application = this.deploymentService.findApplication(trackedApplication);
        NotificationListenerRegistry notificationsListenerRegistry = (NotificationListenerRegistry)application.getRegistry().lookupByType(NotificationListenerRegistry.class).get();
        if (application != null && this.registeredListeners.containsKey(trackedApplication)) {
            for (AgentTrackingListener registeredListener : this.registeredListeners.get(trackedApplication)) {
                notificationsListenerRegistry.unregisterListener((NotificationListener)registeredListener);
            }
            this.registeredListeners.remove(trackedApplication);
        }
    }

    void globalUseDataWeaveFormatForPojo(boolean globalUseDataWeaveFormatForPojo) {
        this.globalUseDataWeaveFormatForPojo = globalUseDataWeaveFormatForPojo;
    }

    void register() {
        for (Application application : this.deploymentService.getApplications()) {
            boolean isTracked = false;
            for (TrackedApplication trackedApplication : this.trackedApplications) {
                if (!trackedApplication.getAppName().equals(application.getArtifactName())) continue;
                isTracked = true;
                this.registerListenersForApplication(trackedApplication, application.getRegistry());
            }
            if (isTracked) continue;
            this.registerListenersForApplication(new TrackedApplication(application.getArtifactName(), this.globalTrackingLevel, this.globalReplayLevel, this.globalPayloadExclusion, this.forceGlobalPayloadInclusion, this.globalUseEventModel), application.getRegistry());
        }
    }

    void unregister() {
        for (String applicationName : this.registeredListeners.keySet()) {
            Application application = this.deploymentService.findApplication(applicationName);
            if (application == null || application.getRegistry() == null) continue;
            Optional notificationsListenerRegistryOptional = application.getRegistry().lookupByType(NotificationListenerRegistry.class);
            notificationsListenerRegistryOptional.ifPresent(notificationsListenerRegistry -> {
                for (AgentTrackingListener registeredListener : this.registeredListeners.get(applicationName)) {
                    notificationsListenerRegistry.unregisterListener((NotificationListener)registeredListener);
                }
            });
        }
        this.registeredListeners.clear();
    }

    private void registerListenersForApplication(TrackedApplication trackedApplication, Registry registry) {
        try {
            if (registry != null) {
                NotificationListenerRegistry notificationsListenerRegistry = (NotificationListenerRegistry)registry.lookupByType(NotificationListenerRegistry.class).get();
                List<AgentTrackingListener> listenersToRegister = TrackingLevelUtils.getListeners(trackedApplication, this.deploymentService, this.trackingNotificationHandlers, this.flowSourceEventHandlers, this.maxPayloadSize, this.maxCollectionSize, this.globalUseDataWeaveFormatForPojo);
                for (AgentTrackingListener agentTrackingListener : listenersToRegister) {
                    notificationsListenerRegistry.registerListener((NotificationListener)agentTrackingListener);
                    this.registeredListeners.put(trackedApplication.getAppName(), listenersToRegister);
                }
            } else {
                LOGGER.warn("Could not start tracking for app " + trackedApplication.getAppName() + " registry is null due to errors on the application initialization. ");
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not start tracking for app " + trackedApplication.getAppName(), (Throwable)e);
        }
    }

    public void onArtifactInitialised(String artifactName, Registry registry) {
        boolean isTracked = false;
        for (TrackedApplication trackedApplication : this.trackedApplications) {
            if (!artifactName.equals(trackedApplication.getAppName())) continue;
            isTracked = true;
            this.registerListenersForApplication(trackedApplication, registry);
        }
        if (!isTracked) {
            TrackedApplication trackedApplication = new TrackedApplication(artifactName, this.globalTrackingLevel, this.globalReplayLevel, this.globalPayloadExclusion, this.forceGlobalPayloadInclusion, this.globalUseEventModel);
            this.registerListenersForApplication(trackedApplication, registry);
        }
    }
}

