/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tracking;

import com.mulesoft.agent.configuration.ApplicationConfiguration;
import com.mulesoft.agent.domain.tracking.ReplayLevel;
import com.mulesoft.agent.domain.tracking.TrackingLevel;
import com.mulesoft.agent.services.tracking.TrackedFlow;
import org.apache.commons.lang3.ArrayUtils;

public class TrackedApplication
implements ApplicationConfiguration {
    private String appName;
    private TrackingLevel trackingLevel;
    private ReplayLevel replayLevel;
    private Boolean payloadExcluded;
    private Boolean forcePayloadInclusion;
    private Boolean useEventModel;
    private TrackedFlow[] trackedFlows;

    public TrackedApplication(String appName, TrackingLevel trackingLevel, ReplayLevel replayLevel) {
        this(appName, trackingLevel, replayLevel, false, false, false, new TrackedFlow[0]);
    }

    public TrackedApplication(String appName, TrackingLevel trackingLevel, ReplayLevel replayLevel, TrackedFlow[] trackedFlows) {
        this(appName, trackingLevel, replayLevel, false, false, false, trackedFlows);
    }

    public TrackedApplication(String appName, TrackingLevel trackingLevel, ReplayLevel replayLevel, Boolean forcePayloadInclusion) {
        this(appName, trackingLevel, replayLevel, false, forcePayloadInclusion, false, new TrackedFlow[0]);
    }

    public TrackedApplication(String appName, TrackingLevel trackingLevel, ReplayLevel replayLevel, Boolean payloadExcluded, Boolean forcePayloadInclusion, Boolean useEventModel) {
        this(appName, trackingLevel, replayLevel, payloadExcluded, forcePayloadInclusion, useEventModel, new TrackedFlow[0]);
    }

    public TrackedApplication(String appName, TrackingLevel trackingLevel, ReplayLevel replayLevel, Boolean payloadExcluded, Boolean forcePayloadInclusion, Boolean useEventModel, TrackedFlow[] trackedFlows) {
        this.appName = appName;
        this.trackingLevel = trackingLevel;
        this.replayLevel = replayLevel;
        this.trackedFlows = trackedFlows;
        this.payloadExcluded = payloadExcluded;
        this.forcePayloadInclusion = forcePayloadInclusion;
        this.useEventModel = useEventModel;
    }

    public String getAppName() {
        return this.appName;
    }

    public TrackingLevel getTrackingLevel() {
        return this.trackingLevel;
    }

    public TrackedFlow[] getTrackedFlows() {
        return this.trackedFlows;
    }

    public ReplayLevel getReplayLevel() {
        return this.replayLevel;
    }

    public Boolean getPayloadExcluded() {
        return this.payloadExcluded;
    }

    public void setPayloadExcluded(Boolean payloadExcluded) {
        this.payloadExcluded = payloadExcluded;
    }

    public Boolean getPayloadInclusionForced() {
        return this.forcePayloadInclusion;
    }

    public Boolean getUseEventModel() {
        return this.useEventModel;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setTrackingLevel(TrackingLevel trackingLevel) {
        this.trackingLevel = trackingLevel;
    }

    public void setReplayLevel(ReplayLevel replayLevel) {
        this.replayLevel = replayLevel;
    }

    public void setForcePayloadInclusion(Boolean forcePayloadInclusion) {
        this.forcePayloadInclusion = forcePayloadInclusion;
    }

    public void setUseEventModel(Boolean useEventModel) {
        this.useEventModel = useEventModel;
    }

    public void setTrackedFlows(TrackedFlow[] trackedFlows) {
        this.trackedFlows = trackedFlows;
    }

    public boolean hasTrackedFlows() {
        return this.trackedFlows != null && this.trackedFlows.length != 0;
    }

    public TrackedFlow[] addTrackedFlow(TrackedFlow trackedFlow) {
        if (this.trackedFlows == null) {
            this.trackedFlows = new TrackedFlow[0];
        }
        this.removeTrackedFlow(trackedFlow);
        this.trackedFlows = (TrackedFlow[])ArrayUtils.add((Object[])this.trackedFlows, (Object)trackedFlow);
        return this.trackedFlows;
    }

    public TrackedFlow[] removeTrackedFlow(TrackedFlow trackedFlow) {
        int idx = ArrayUtils.indexOf((Object[])this.trackedFlows, (Object)trackedFlow);
        if (idx >= 0) {
            this.trackedFlows = (TrackedFlow[])ArrayUtils.remove((Object[])this.trackedFlows, (int)idx);
        }
        return this.trackedFlows;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrackedApplication)) {
            return false;
        }
        TrackedApplication that = (TrackedApplication)o;
        return !(this.appName != null ? !this.appName.equals(that.appName) : that.appName != null);
    }

    public int hashCode() {
        return this.appName != null ? this.appName.hashCode() : 0;
    }
}

