/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tracking;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.ConfigurationLevel;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.domain.tracking.FlowSourceEvent;
import com.mulesoft.agent.domain.tracking.ReplayLevel;
import com.mulesoft.agent.domain.tracking.TrackingLevel;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.RuntimeVersionService;
import com.mulesoft.agent.services.TrackingService;
import com.mulesoft.agent.services.tracking.TrackedApplication;
import com.mulesoft.agent.services.tracking.TrackedFlow;
import com.mulesoft.agent.services.tracking.TrackingDeploymentListener;
import com.mulesoft.agent.tracking.ReplayStore;
import com.mulesoft.agent.util.IOCUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.message.DefaultMessageBuilder;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

@Named(value="mule.agent.tracking.service")
@Singleton
public class AgentTrackingService
extends ConfigurableAgentService
implements TrackingService,
DeploymentServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(AgentTrackingService.class);
    @Configurable(value="NONE", type=Type.DYNAMIC)
    private TrackingLevel globalTrackingLevel;
    @Configurable(value="NONE", type=Type.DYNAMIC)
    private ReplayLevel globalReplayLevel;
    @Configurable(value="false", type=Type.DYNAMIC)
    private boolean globalPayloadExclusion;
    @Configurable(value="false", type=Type.DYNAMIC)
    private boolean forceGlobalPayloadInclusion;
    @Configurable(value="false", type=Type.DYNAMIC)
    private boolean globalUseEventModel;
    @Configurable(value="10240", type=Type.DYNAMIC)
    private long maxPayloadSizeForCursorStreams;
    @Configurable(value="-1", type=Type.DYNAMIC)
    private long maxCollectionSize;
    @Configurable(value="false", type=Type.DYNAMIC)
    private boolean globalUseDataWeaveFormatForPojo = false;
    @Deprecated
    @Configurable(value="UTF-8", type=Type.DYNAMIC)
    private String defaultCharsetForPojosAsJson;
    @Configurable(value="[]", type=Type.DYNAMIC, level=ConfigurationLevel.APPLICATION)
    private TrackedApplication[] trackedApplications;
    private DeploymentService deploymentService;
    private TrackingDeploymentListener trackingDeploymentListener;
    @Inject
    private RuntimeVersionService runtimeVersionService;
    @Inject
    private Set<InternalMessageHandler<AgentTrackingNotification>> notificationHandlers;
    @Inject
    private Set<InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlers;
    @Inject
    private List<ReplayStore> replayStores;
    private Map<String, InternalMessageHandler<AgentTrackingNotification>> notificationHandlersMap;
    private Map<String, InternalMessageHandler<FlowSourceEvent>> flowSourceEventHandlersMap;
    private boolean started = false;

    @PostConfigure
    public void runPostConfiguration() {
        for (TrackedApplication trackedApplication : this.trackedApplications) {
            if (trackedApplication.getTrackedFlows() != null) {
                for (TrackedFlow trackedFlow : trackedApplication.getTrackedFlows()) {
                    if (!trackedFlow.getTrackingLevel().isAboveLevel(trackedApplication.getTrackingLevel())) continue;
                    LOGGER.warn("Tracking level " + trackedFlow.getTrackingLevel() + " for flow " + trackedFlow.getFlowName() + " is above global tracking level " + trackedApplication.getTrackingLevel() + " for application " + trackedApplication.getAppName() + ". Flow tracking level will be set to " + trackedApplication.getTrackingLevel());
                }
            }
            this.configureTrackedApplicationDefaults(trackedApplication);
        }
    }

    public void track(String applicationName, TrackingLevel trackingLevel, ReplayLevel replayLevel, boolean isPayloadExcluded, boolean isPayloadInclusionEnforced, boolean useEventModel) {
        TrackedApplication applicationToTrack = new TrackedApplication(applicationName, trackingLevel, replayLevel, isPayloadExcluded, isPayloadInclusionEnforced, useEventModel);
        int index = ArrayUtils.indexOf((Object[])this.trackedApplications, (Object)applicationToTrack);
        if (index >= 0) {
            this.trackedApplications[index] = applicationToTrack;
        } else {
            this.trackedApplications = (TrackedApplication[])ArrayUtils.add((Object[])this.trackedApplications, (Object)applicationToTrack);
        }
        this.trackingDeploymentListener.setTrackedApplications(this.trackedApplications);
        this.trackingDeploymentListener.untrackApplication(applicationToTrack.getAppName());
        this.trackingDeploymentListener.trackApplication(applicationToTrack);
    }

    public void track(String applicationName, String flowName, TrackingLevel trackingLevel, ReplayLevel replayLevel, boolean isPayloadExcluded, boolean isPayloadInclusionEnforced, boolean useEventModel) {
        TrackedFlow flowToTrack = new TrackedFlow(flowName, trackingLevel, replayLevel, isPayloadExcluded, isPayloadInclusionEnforced, useEventModel);
        TrackedFlow[] flowsToTrack = new TrackedFlow[]{flowToTrack};
        TrackedApplication applicationToTrack = new TrackedApplication(applicationName, trackingLevel, replayLevel, flowsToTrack);
        int index = ArrayUtils.indexOf((Object[])this.trackedApplications, (Object)applicationToTrack);
        if (index >= 0) {
            this.trackedApplications[index].addTrackedFlow(flowToTrack);
        } else {
            this.trackedApplications = (TrackedApplication[])ArrayUtils.add((Object[])this.trackedApplications, (Object)applicationToTrack);
        }
        this.trackingDeploymentListener.setTrackedApplications(this.trackedApplications);
        this.trackingDeploymentListener.untrackApplication(applicationToTrack.getAppName());
        this.trackingDeploymentListener.trackApplication(applicationToTrack);
    }

    public void untrack(String applicationName) {
        TrackedApplication applicationToUntrack = new TrackedApplication(applicationName, this.globalTrackingLevel, this.globalReplayLevel);
        if (ArrayUtils.contains((Object[])this.trackedApplications, (Object)applicationToUntrack)) {
            this.trackedApplications = (TrackedApplication[])ArrayUtils.removeElement((Object[])this.trackedApplications, (Object)applicationToUntrack);
            this.trackingDeploymentListener.setTrackedApplications(this.trackedApplications);
            this.trackingDeploymentListener.untrackApplication(applicationName);
            this.trackingDeploymentListener.trackApplication(applicationToUntrack);
        }
    }

    public void untrack(String applicationName, String flowName) {
        TrackedFlow flowToUntrack = new TrackedFlow(flowName, this.globalTrackingLevel, this.globalReplayLevel);
        TrackedApplication applicationToTrack = new TrackedApplication(applicationName, this.globalTrackingLevel, this.globalReplayLevel);
        int index = ArrayUtils.indexOf((Object[])this.trackedApplications, (Object)applicationToTrack);
        if (index >= 0) {
            TrackedFlow[] trackedFlows = this.trackedApplications[index].removeTrackedFlow(flowToUntrack);
            applicationToTrack = new TrackedApplication(applicationName, this.trackedApplications[index].getTrackingLevel(), this.trackedApplications[index].getReplayLevel(), trackedFlows);
            this.trackingDeploymentListener.setTrackedApplications(this.trackedApplications);
            this.trackingDeploymentListener.untrackApplication(applicationName);
            this.trackingDeploymentListener.trackApplication(applicationToTrack);
        }
    }

    public void replay(String applicationName, String flowName, String transactionId) {
        FlowSourceEvent flowSourceEvent = null;
        Application application = this.deploymentService.findApplication(applicationName);
        if (application == null) {
            LOGGER.error("The flow could not be replayed because the application cannot be found.");
            throw new IllegalArgumentException("The flow could not be replayed because the application cannot be found.");
        }
        for (ReplayStore replayStore : this.replayStores) {
            FlowSourceEvent storedEvent = replayStore.getFlowSourceEvent(applicationName, flowName, transactionId, application.getArtifactClassLoader().getClassLoader());
            if (storedEvent == null) continue;
            flowSourceEvent = storedEvent;
            break;
        }
        if (flowSourceEvent == null) {
            LOGGER.error("The flow could not be replayed because the original event cannot be found.");
            throw new IllegalArgumentException("The flow could not be replayed because the original event cannot be found.");
        }
        this.replay(applicationName, flowName, flowSourceEvent);
    }

    public void replay(String applicationName, String flowName, FlowSourceEvent flowSourceEvent) {
        Application application = this.deploymentService.findApplication(applicationName);
        if (application == null) {
            LOGGER.error("The flow could not be replayed because the application cannot be found");
            throw new IllegalArgumentException("The flow could not be replayed because the application cannot be found.");
        }
        FlowConstruct flowConstruct = (FlowConstruct)application.getRegistry().lookupByName(flowName).orElseThrow(() -> new IllegalArgumentException(String.format("Could not get flow %s for application %s.", flowName, applicationName)));
        Object payload = flowSourceEvent.getPayload();
        if (payload == null) {
            LOGGER.error("The flow could not be replayed because the original event cannot be found.");
            throw new IllegalArgumentException("The flow could not be replayed because the original event cannot be found.");
        }
        ClassUtils.withContextClassLoader((ClassLoader)application.getArtifactClassLoader().getClassLoader(), () -> {
            DefaultMessageBuilder builder = new DefaultMessageBuilder();
            builder.value(payload).mediaType(flowSourceEvent.getDataType().getMediaType());
            CoreEvent muleEvent = CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)flowConstruct, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)"AgentTrackingService"))).message((Message)builder.build()).build();
            try {
                ((Flow)flowConstruct).process(muleEvent);
            }
            catch (MuleException e) {
                LOGGER.error("The flow failed while attempting replay: " + e.getMessage());
                throw new RuntimeException("The flow failed while attempting replay: " + e.getMessage());
            }
        });
    }

    protected void doStart() throws MuleException {
        this.notificationHandlersMap = IOCUtils.toNamedMap(this.notificationHandlers);
        this.flowSourceEventHandlersMap = IOCUtils.toNamedMap(this.flowSourceEventHandlers);
        if (this.trackingDeploymentListener == null) {
            this.trackingDeploymentListener = new TrackingDeploymentListener(this.deploymentService, this.notificationHandlersMap, this.flowSourceEventHandlersMap);
        }
        this.trackingDeploymentListener.setGlobalTrackingLevel(this.globalTrackingLevel);
        this.trackingDeploymentListener.setGlobalPayloadExclusion(this.globalPayloadExclusion);
        this.trackingDeploymentListener.setForceGlobalPayloadInclusion(this.forceGlobalPayloadInclusion);
        this.trackingDeploymentListener.setGlobalUseEventModel(this.globalUseEventModel);
        this.trackingDeploymentListener.setMaxPayloadSize(this.maxPayloadSizeForCursorStreams);
        if (this.runtimeVersionService.supportsDataWeaveMaxCollectionSize()) {
            this.trackingDeploymentListener.setMaxCollectionSize(this.maxCollectionSize);
        } else {
            LOGGER.debug("Ignored maxCollectionSize since it is not supported by Mule Runtime");
        }
        this.trackingDeploymentListener.globalUseDataWeaveFormatForPojo(this.globalUseDataWeaveFormatForPojo);
        this.trackingDeploymentListener.setGlobalReplayLevel(this.globalReplayLevel);
        if (this.trackedApplications == null) {
            this.trackedApplications = new TrackedApplication[0];
        }
        this.trackingDeploymentListener.setTrackedApplications(this.trackedApplications);
        this.trackingDeploymentListener.unregister();
        this.trackingDeploymentListener.register();
        this.deploymentService.addDeploymentListener((DeploymentListener)this.trackingDeploymentListener);
    }

    protected void doStop() throws MuleException {
        this.trackingDeploymentListener.unregister();
        this.deploymentService.removeDeploymentListener((DeploymentListener)this.trackingDeploymentListener);
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.notificationHandlers);
    }

    private void configureTrackedApplicationDefaults(TrackedApplication trackedApplication) {
        if (trackedApplication.getPayloadExcluded() == null) {
            trackedApplication.setPayloadExcluded(this.globalPayloadExclusion);
        }
        if (trackedApplication.getPayloadInclusionForced() == null) {
            trackedApplication.setForcePayloadInclusion(this.forceGlobalPayloadInclusion);
        }
        if (trackedApplication.getTrackingLevel() == null) {
            trackedApplication.setTrackingLevel(this.globalTrackingLevel);
        }
        if (trackedApplication.getReplayLevel() == null) {
            trackedApplication.setReplayLevel(this.globalReplayLevel);
        }
        if (trackedApplication.getUseEventModel() == null) {
            trackedApplication.setUseEventModel(this.globalUseEventModel);
        }
    }
}

