/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsyncClient;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.services.OnOffSwitch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;

@Named(value="cloudwatch.agent.monitor.publisher")
@Singleton
public class CloudwatchMonitorPublisher
extends BufferedHandler<ArrayList<Metric>> {
    @Configurable(value="com.mulesoft.agent")
    String namespace;
    @Configurable(value="missingAccessKey")
    String accessKey;
    @Configurable(value="missingSecretKey")
    String secretKey;

    @Inject
    public CloudwatchMonitorPublisher() {
    }

    public CloudwatchMonitorPublisher(OnOffSwitch enabledSwitch) {
        this.enabledSwitch = enabledSwitch;
    }

    public boolean canHandle(@NotNull ArrayList<Metric> metrics) {
        return true;
    }

    public boolean flush(@NotNull Collection<ArrayList<Metric>> listOfMetrics) {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        AmazonCloudWatchAsyncClient cloudWatchClient = new AmazonCloudWatchAsyncClient((AWSCredentials)credentials);
        for (List list : listOfMetrics) {
            List<MetricDatum> cloudWatchMetrics = CloudwatchMonitorPublisher.transformMetrics(list);
            PutMetricDataRequest putMetricDataRequest = new PutMetricDataRequest();
            putMetricDataRequest.setMetricData(cloudWatchMetrics);
            putMetricDataRequest.setNamespace(this.namespace);
            cloudWatchClient.putMetricData(putMetricDataRequest);
        }
        return true;
    }

    private static List<MetricDatum> transformMetrics(List<Metric> metrics) {
        LinkedList<MetricDatum> cloudWatchMetrics = new LinkedList<MetricDatum>();
        for (Metric metric : metrics) {
            MetricDatum cloudwatchMetric = new MetricDatum();
            cloudwatchMetric.setMetricName(metric.getName());
            cloudwatchMetric.setValue(Double.valueOf(metric.getValue().doubleValue()));
            cloudwatchMetric.setTimestamp(new Date(metric.getTimestamp()));
            cloudWatchMetrics.add(cloudwatchMetric);
        }
        return cloudWatchMetrics;
    }
}

